/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx.handler;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Attributes;

public class ContextHandlerMBean
extends ObjectMBean {
    public ContextHandlerMBean(Object managedObject) {
        super(managedObject);
    }

    public String getObjectNameBasis() {
        if (this._managed != null && this._managed instanceof ContextHandler) {
            ContextHandler context = (ContextHandler)this._managed;
            String name = context.getDisplayName();
            if (name != null) {
                return name;
            }
            if (context.getBaseResource() != null && context.getBaseResource().getName().length() > 1) {
                return context.getBaseResource().getName();
            }
        }
        return super.getObjectNameBasis();
    }

    public Map getContextAttributes() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Attributes attrs = ((ContextHandler)this._managed).getAttributes();
        Enumeration en = attrs.getAttributeNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            Object value = attrs.getAttribute(name);
            map.put(name, value);
        }
        return map;
    }

    public void setContextAttribute(String name, Object value) {
        Attributes attrs = ((ContextHandler)this._managed).getAttributes();
        attrs.setAttribute(name, value);
    }

    public void setContextAttribute(String name, String value) {
        Attributes attrs = ((ContextHandler)this._managed).getAttributes();
        attrs.setAttribute(name, (Object)value);
    }

    public void removeContextAttribute(String name) {
        Attributes attrs = ((ContextHandler)this._managed).getAttributes();
        attrs.removeAttribute(name);
    }
}

