/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class MBeanContainer
implements Container.InheritedListener,
Dumpable {
    private static final Logger LOG = Log.getLogger((String)MBeanContainer.class.getName());
    private static final ConcurrentMap<String, AtomicInteger> __unique = new ConcurrentHashMap<String, AtomicInteger>();
    private final MBeanServer _mbeanServer;
    private final Map<Object, ObjectName> _beans = new ConcurrentHashMap<Object, ObjectName>();
    private String _domain = null;

    public static void resetUnique() {
        __unique.clear();
    }

    public ObjectName findMBean(Object object) {
        return this._beans.get(object);
    }

    public Object findBean(ObjectName objectName) {
        for (Map.Entry<Object, ObjectName> entry : this._beans.entrySet()) {
            if (!entry.getKey().equals(objectName)) continue;
            return entry.getValue();
        }
        return null;
    }

    public MBeanContainer(MBeanServer server) {
        this._mbeanServer = server;
    }

    public MBeanServer getMBeanServer() {
        return this._mbeanServer;
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    public String getDomain() {
        return this._domain;
    }

    public void beanAdded(Container parent, Object obj) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("beanAdded {}->{}", new Object[]{parent, obj});
        }
        ObjectName parentObjectName = null;
        if (parent != null && (parentObjectName = this.findMBean(parent)) == null) {
            this.beanAdded(null, parent);
            parentObjectName = this.findMBean(parent);
        }
        if (obj == null || this._beans.containsKey(obj)) {
            return;
        }
        try {
            Object mbean = ObjectMBean.mbeanFor(obj);
            if (mbean == null) {
                return;
            }
            ObjectName objectName = null;
            if (mbean instanceof ObjectMBean) {
                ((ObjectMBean)mbean).setMBeanContainer(this);
                objectName = ((ObjectMBean)mbean).getObjectName();
            }
            if (objectName == null) {
                AtomicInteger existing;
                String basis;
                AtomicInteger count;
                String name;
                String context;
                String type;
                int dot;
                String domain = this._domain;
                if (domain == null) {
                    domain = obj.getClass().getPackage().getName();
                }
                if ((dot = (type = obj.getClass().getName().toLowerCase(Locale.ENGLISH)).lastIndexOf(46)) >= 0) {
                    type = type.substring(dot + 1);
                }
                StringBuilder buf = new StringBuilder();
                String string = context = mbean instanceof ObjectMBean ? this.makeName(((ObjectMBean)mbean).getObjectContextBasis()) : null;
                if (context == null && parentObjectName != null) {
                    context = parentObjectName.getKeyProperty("context");
                }
                if (context != null && context.length() > 1) {
                    buf.append("context=").append(context).append(",");
                }
                buf.append("type=").append(type);
                String string2 = name = mbean instanceof ObjectMBean ? this.makeName(((ObjectMBean)mbean).getObjectNameBasis()) : context;
                if (name != null && name.length() > 1) {
                    buf.append(",").append("name=").append(name);
                }
                if ((count = (AtomicInteger)__unique.get(basis = buf.toString())) == null && (existing = __unique.putIfAbsent(basis, count = new AtomicInteger())) != null) {
                    count = existing;
                }
                objectName = ObjectName.getInstance(domain + ":" + basis + ",id=" + count.getAndIncrement());
            }
            this._mbeanServer.registerMBean(mbean, objectName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registered {}", new Object[]{objectName});
            }
            this._beans.put(obj, objectName);
        }
        catch (Throwable x) {
            LOG.warn("bean: " + obj, x);
        }
    }

    public void beanRemoved(Container parent, Object obj) {
        ObjectName objectName;
        if (LOG.isDebugEnabled()) {
            LOG.debug("beanRemoved {}", new Object[]{obj});
        }
        if ((objectName = this._beans.remove(obj)) != null) {
            this.unregister(objectName);
        }
    }

    public String makeName(String basis) {
        if (basis == null) {
            return null;
        }
        return basis.replace(':', '_').replace('*', '_').replace('?', '_').replace('=', '_').replace(',', '_').replace(' ', '_');
    }

    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dumpObject((Appendable)out, (Object)this);
        ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{this._beans.entrySet()});
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void destroy() {
        this._beans.values().stream().filter(objectName -> objectName != null).forEach(this::unregister);
    }

    private void unregister(ObjectName objectName) {
        try {
            this.getMBeanServer().unregisterMBean(objectName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unregistered {}", new Object[]{objectName});
            }
        }
        catch (InstanceNotFoundException | MBeanRegistrationException x) {
            LOG.ignore((Throwable)x);
        }
        catch (Throwable x) {
            LOG.warn(x);
        }
    }
}

