package org.eclipse.jetty.jspc.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on jetty-jspc-maven-plugin.<br/> Call <pre>  mvn jetty-jspc:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Wed Mar 25 09:38:49 CDT 2015
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.9)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.eclipse.jetty:jetty-jspc-maven-plugin:9.2.11.M0", 0 );
        append( sb, "", 0 );

        append( sb, "Jetty :: Jetty JSPC Maven Plugin", 0 );
        append( sb, "Administrative parent pom for Jetty modules", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 2 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "jetty-jspc:help", 0 );
            append( sb, "Display help information on jetty-jspc-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jetty-jspc:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jspc".equals( goal ) )
        {
            append( sb, "jetty-jspc:jspc", 0 );
            append( sb, "This goal will compile jsps for a webapp so that they can be included in a war.\n\nAt runtime, the plugin will use the jsp2.0 jspc compiler if you are running on a 1.4 or lower jvm. If you are using a 1.5 jvm, then the jsp2.1 compiler will be selected. (this is the same behaviour as the jetty plugin for executing webapps).\n\nNote that the same java compiler will be used as for on-the-fly compiled jsps, which will be the Eclipse java compiler.\n\nSee Usage Guide for instructions on using this plugin.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "classesDirectory", 2 );
                append( sb, "The location of the compiled classes for the webapp", 3 );
                append( sb, "Expression: ${project.build.outputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "The comma separated list of file name patters to exclude from compilation.", 3 );
                append( sb, "", 0 );

                append( sb, "generatedClasses (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "The destination directory into which to put the compiled jsps.", 3 );
                append( sb, "", 0 );

                append( sb, "includes (Default: **/*.jsp, **/*.jspx)", 2 );
                append( sb, "The comma separated list of patterns for file extensions to be processed. By default will include all .jsp and .jspx files.", 3 );
                append( sb, "", 0 );

                append( sb, "insertionMarker", 2 );
                append( sb, "Optional. A marker string in the src web.xml file which indicates where to merge in the generated web.xml fragment. Note that the marker string will NOT be preserved during the insertion. Can be left blank, in which case the generated fragment is inserted just before the </web-app> line", 3 );
                append( sb, "", 0 );

                append( sb, "jspc", 2 );
                append( sb, "The JspC instance being used to compile the jsps.", 3 );
                append( sb, "", 0 );

                append( sb, "keepSources (Default: false)", 2 );
                append( sb, "Controls whether or not .java files generated during compilation will be preserved.", 3 );
                append( sb, "", 0 );

                append( sb, "mergeFragment (Default: true)", 2 );
                append( sb, "Merge the generated fragment file with the web.xml from webAppSourceDirectory. The merged file will go into the same directory as the webXmlFragment.", 3 );
                append( sb, "", 0 );

                append( sb, "tldJarNamePatterns (Default: .*taglibs[^/]*.jar|.*jstl[^/]*.jar$)", 2 );
                append( sb, "Patterns of jars on the system path that contain tlds. Use | to separate each pattern.", 3 );
                append( sb, "", 0 );

                append( sb, "useProvidedScope (Default: false)", 2 );
                append( sb, "Whether or not to include dependencies on the plugin\'s classpath with <scope>provided</scope> Use WITH CAUTION as you may wind up with duplicate jars/classes.", 3 );
                append( sb, "", 0 );

                append( sb, "webAppSourceDirectory (Default: ${basedir}/src/main/webapp)", 2 );
                append( sb, "Root directory for all html/jsp etc files", 3 );
                append( sb, "", 0 );

                append( sb, "webXml (Default: ${basedir}/src/main/webapp/WEB-INF/web.xml)", 2 );
                append( sb, "Location of web.xml. Defaults to src/main/webapp/web.xml.", 3 );
                append( sb, "", 0 );

                append( sb, "webXmlFragment (Default: ${basedir}/target/webfrag.xml)", 2 );
                append( sb, "File into which to generate the <servlet> and <servlet-mapping> tags for the compiled jsps", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
