/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.maven.plugin.JettyWebAppContext;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.xml.XmlConfiguration;

public class WebAppPropertyConverter {
    public static void toProperties(JettyWebAppContext webApp, File propsFile, String contextXml) throws Exception {
        if (webApp == null) {
            throw new IllegalArgumentException("No webapp");
        }
        if (propsFile == null) {
            throw new IllegalArgumentException("No properties file");
        }
        if (propsFile.exists()) {
            propsFile.delete();
        }
        propsFile.createNewFile();
        Properties props = new Properties();
        if (webApp.getDescriptor() != null) {
            props.put("web.xml", webApp.getDescriptor());
        }
        if (webApp.getQuickStartWebDescriptor() != null) {
            props.put("quickstart.web.xml", webApp.getQuickStartWebDescriptor().getFile().getAbsolutePath());
        }
        if (webApp.getContextPath() != null) {
            props.put("context.path", webApp.getContextPath());
        }
        props.put("tmp.dir", webApp.getTempDirectory().getAbsolutePath());
        props.put("tmp.dir.persist", Boolean.toString(webApp.isPersistTempDirectory()));
        Resource baseResource = webApp.getBaseResource();
        if (baseResource instanceof ResourceCollection) {
            props.put("base.dirs", WebAppPropertyConverter.toCSV(((ResourceCollection)webApp.getBaseResource()).getResources()));
        } else {
            props.put("base.dirs", webApp.getBaseResource().toString());
        }
        if (webApp.getClasses() != null) {
            props.put("classes.dir", webApp.getClasses().getAbsolutePath());
        }
        if (webApp.getTestClasses() != null) {
            props.put("testClasses.dir", webApp.getTestClasses().getAbsolutePath());
        }
        List<File> deps = webApp.getWebInfLib();
        StringBuilder strbuff = new StringBuilder();
        if (deps != null) {
            for (int i = 0; i < deps.size(); ++i) {
                File d = deps.get(i);
                strbuff.append(d.getAbsolutePath());
                if (i >= deps.size() - 1) continue;
                strbuff.append(",");
            }
        }
        props.put("lib.jars", strbuff.toString());
        if (contextXml != null) {
            props.put("context.xml", contextXml);
        }
        try (BufferedWriter out = Files.newBufferedWriter(propsFile.toPath(), new OpenOption[0]);){
            props.store(out, "properties for forked webapp");
        }
    }

    public static void fromProperties(JettyWebAppContext webApp, String resource, Server server, Map<String, String> jettyProperties) throws Exception {
        if (resource == null) {
            throw new IllegalStateException("No resource");
        }
        WebAppPropertyConverter.fromProperties(webApp, Resource.newResource((String)resource).getFile(), server, jettyProperties);
    }

    public static void fromProperties(JettyWebAppContext webApp, File propsFile, Server server, Map<String, String> jettyProperties) throws Exception {
        if (webApp == null) {
            throw new IllegalArgumentException("No webapp");
        }
        if (propsFile == null) {
            throw new IllegalArgumentException("No properties file");
        }
        if (!propsFile.exists()) {
            throw new IllegalArgumentException(propsFile.getCanonicalPath() + " does not exist");
        }
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(propsFile.toPath(), new OpenOption[0]);){
            props.load(in);
        }
        String str = props.getProperty("context.path");
        if (!StringUtil.isBlank((String)str)) {
            webApp.setContextPath(str);
        }
        if (!StringUtil.isBlank((String)(str = props.getProperty("web.xml")))) {
            webApp.setDescriptor(str);
        }
        if (!StringUtil.isBlank((String)(str = props.getProperty("quickstart.web.xml")))) {
            webApp.setQuickStartWebDescriptor(Resource.newResource((File)new File(str)));
        }
        if (!StringUtil.isBlank((String)(str = props.getProperty("tmp.dir")))) {
            webApp.setTempDirectory(new File(str.trim()));
        }
        if (!StringUtil.isBlank((String)(str = props.getProperty("tmp.dir.persist")))) {
            webApp.setPersistTempDirectory(Boolean.valueOf(str));
        }
        if (!StringUtil.isBlank((String)(str = props.getProperty("base.dirs")))) {
            ResourceCollection bases = new ResourceCollection(StringUtil.csvSplit((String)str));
            webApp.setWar(null);
            webApp.setBaseResource((Resource)bases);
        }
        if (!StringUtil.isBlank((String)(str = props.getProperty("classes.dir")))) {
            webApp.setClasses(new File(str));
        }
        if (!StringUtil.isBlank((String)(str = props.getProperty("testClasses.dir")))) {
            webApp.setTestClasses(new File(str));
        }
        if (!StringUtil.isBlank((String)(str = props.getProperty("lib.jars")))) {
            ArrayList<File> jars = new ArrayList<File>();
            String[] names = StringUtil.csvSplit((String)str);
            for (int j = 0; names != null && j < names.length; ++j) {
                jars.add(new File(names[j].trim()));
            }
            webApp.setWebInfLib(jars);
        }
        if (!StringUtil.isBlank((String)(str = props.getProperty("context.xml")))) {
            XmlConfiguration xmlConfiguration = new XmlConfiguration(Resource.newResource((String)str));
            xmlConfiguration.getIdMap().put("Server", server);
            if (jettyProperties != null) {
                for (Map.Entry<String, String> prop : jettyProperties.entrySet()) {
                    xmlConfiguration.getProperties().put(prop.getKey(), prop.getValue());
                }
            }
            xmlConfiguration.configure((Object)webApp);
        }
    }

    private static String toCSV(Resource[] resources) {
        StringBuilder rb = new StringBuilder();
        for (Resource r : resources) {
            if (rb.length() > 0) {
                rb.append(",");
            }
            rb.append(r.toString());
        }
        return rb.toString();
    }
}

