/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.jetty.maven.plugin.OverlayConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarPluginInfo {
    private MavenProject _project;
    private Plugin _plugin;
    private List<String> _dependentMavenWarIncludes;
    private List<String> _dependentMavenWarExcludes;
    private List<OverlayConfig> _overlayConfigs;

    public WarPluginInfo(MavenProject project) {
        this._project = project;
    }

    public Plugin getPlugin() {
        if (this._plugin == null) {
            List plugins = this._project.getBuildPlugins();
            if (plugins == null) {
                return null;
            }
            Iterator itor = plugins.iterator();
            while (itor.hasNext() && this._plugin == null) {
                Plugin plugin = (Plugin)itor.next();
                if (!"maven-war-plugin".equals(plugin.getArtifactId())) continue;
                this._plugin = plugin;
            }
        }
        return this._plugin;
    }

    public List<String> getDependentMavenWarIncludes() {
        if (this._dependentMavenWarIncludes == null) {
            this.getPlugin();
            if (this._plugin == null) {
                return null;
            }
            Xpp3Dom node = (Xpp3Dom)this._plugin.getConfiguration();
            if (node == null) {
                return null;
            }
            if ((node = node.getChild("dependentWarIncludes")) == null) {
                return null;
            }
            String val = node.getValue();
            this._dependentMavenWarIncludes = Arrays.asList(val.split(","));
        }
        return this._dependentMavenWarIncludes;
    }

    public List<String> getDependentMavenWarExcludes() {
        if (this._dependentMavenWarExcludes == null) {
            this.getPlugin();
            if (this._plugin == null) {
                return null;
            }
            Xpp3Dom node = (Xpp3Dom)this._plugin.getConfiguration();
            if (node == null) {
                return null;
            }
            if ((node = node.getChild("dependentWarExcludes")) == null) {
                return null;
            }
            String val = node.getValue();
            this._dependentMavenWarExcludes = Arrays.asList(val.split(","));
        }
        return this._dependentMavenWarExcludes;
    }

    public List<OverlayConfig> getMavenWarOverlayConfigs() {
        if (this._overlayConfigs == null) {
            this.getPlugin();
            if (this._plugin == null) {
                return Collections.emptyList();
            }
            this.getDependentMavenWarIncludes();
            this.getDependentMavenWarExcludes();
            Xpp3Dom node = (Xpp3Dom)this._plugin.getConfiguration();
            if (node == null) {
                return Collections.emptyList();
            }
            if ((node = node.getChild("overlays")) == null) {
                return Collections.emptyList();
            }
            Xpp3Dom[] nodes = node.getChildren("overlay");
            if (nodes == null) {
                return Collections.emptyList();
            }
            this._overlayConfigs = new ArrayList<OverlayConfig>();
            for (int i = 0; i < nodes.length; ++i) {
                OverlayConfig overlayConfig = new OverlayConfig(nodes[i], this._dependentMavenWarIncludes, this._dependentMavenWarExcludes);
                this._overlayConfigs.add(overlayConfig);
            }
        }
        return this._overlayConfigs;
    }

    public String getMavenWarOverlayConfigAsString() {
        this.getPlugin();
        if (this._plugin == null) {
            return "";
        }
        Xpp3Dom node = (Xpp3Dom)this._plugin.getConfiguration();
        if (node == null) {
            return "";
        }
        return node.toString();
    }
}

