/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jetty.maven.plugin.JettyWebAppContext;
import org.eclipse.jetty.maven.plugin.Overlay;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;

public class MavenWebInfConfiguration
extends WebInfConfiguration {
    private static final Logger LOG = Log.getLogger(WebInfConfiguration.class);
    protected static int COUNTER = 0;
    protected Resource _originalResourceBase;
    protected List<Resource> _unpackedOverlayResources;

    public void configure(WebAppContext context) throws Exception {
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (jwac.getClassPathFiles() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting up classpath ...", new Object[0]);
            }
            Iterator<File> itor = jwac.getClassPathFiles().iterator();
            while (itor.hasNext()) {
                ((WebAppClassLoader)context.getClassLoader()).addClassPath(itor.next().getCanonicalPath());
            }
        }
        super.configure(context);
        String[] existingServerClasses = context.getServerClasses();
        String[] newServerClasses = new String[2 + (existingServerClasses == null ? 0 : existingServerClasses.length)];
        newServerClasses[0] = "org.apache.maven.";
        newServerClasses[1] = "org.codehaus.plexus.";
        System.arraycopy(existingServerClasses, 0, newServerClasses, 2, existingServerClasses.length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Server classes:", new Object[0]);
            for (int i = 0; i < newServerClasses.length; ++i) {
                LOG.debug(newServerClasses[i], new Object[0]);
            }
        }
        context.setServerClasses(newServerClasses);
    }

    public void preConfigure(WebAppContext context) throws Exception {
        super.preConfigure(context);
    }

    public void postConfigure(WebAppContext context) throws Exception {
        super.postConfigure(context);
    }

    public void deconfigure(WebAppContext context) throws Exception {
        if (this._unpackedOverlayResources != null && !this._unpackedOverlayResources.isEmpty()) {
            try {
                for (Resource r : this._unpackedOverlayResources) {
                    IO.delete((File)r.getFile());
                }
            }
            catch (IOException e) {
                LOG.ignore((Throwable)e);
            }
        }
        super.deconfigure(context);
        context.setBaseResource(this._originalResourceBase);
    }

    public void unpack(WebAppContext context) throws IOException {
        super.unpack(context);
        this._originalResourceBase = context.getBaseResource();
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        this._unpackedOverlayResources = new ArrayList<Resource>();
        if (jwac.getOverlays() != null && !jwac.getOverlays().isEmpty()) {
            ArrayList<Resource> resourceBaseCollection = new ArrayList<Resource>();
            for (Overlay o : jwac.getOverlays()) {
                if (o.getConfig() != null && o.getConfig().isCurrentProject() && this._originalResourceBase.exists()) {
                    resourceBaseCollection.add(this._originalResourceBase);
                    LOG.info("Adding virtual project to resource base list", new Object[0]);
                    continue;
                }
                Resource unpacked = this.unpackOverlay(jwac, o);
                this._unpackedOverlayResources.add(unpacked);
                resourceBaseCollection.add(unpacked);
                LOG.info("Adding " + unpacked + " to resource base list", new Object[0]);
            }
            if (!resourceBaseCollection.contains(this._originalResourceBase) && this._originalResourceBase.exists()) {
                if (jwac.getBaseAppFirst()) {
                    LOG.info("Adding virtual project first in resource base list", new Object[0]);
                    resourceBaseCollection.add(0, this._originalResourceBase);
                } else {
                    LOG.info("Adding virtual project last in resource base list", new Object[0]);
                    resourceBaseCollection.add(this._originalResourceBase);
                }
            }
            jwac.setBaseResource((Resource)new ResourceCollection(resourceBaseCollection.toArray(new Resource[resourceBaseCollection.size()])));
        }
    }

    protected List<Resource> findJars(WebAppContext context) throws Exception {
        List superList;
        ArrayList<Resource> list = new ArrayList<Resource>();
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (jwac.getClassPathFiles() != null) {
            for (File f : jwac.getClassPathFiles()) {
                if (!f.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar")) continue;
                try {
                    list.add(Resource.newResource((URI)f.toURI()));
                }
                catch (Exception e) {
                    LOG.warn("Bad url ", (Throwable)e);
                }
            }
        }
        if ((superList = super.findJars(context)) != null) {
            list.addAll(superList);
        }
        return list;
    }

    protected Resource unpackOverlay(WebAppContext context, Overlay overlay) throws IOException {
        File dir;
        int i;
        LOG.info("Unpacking overlay: " + overlay, new Object[0]);
        this.resolveTempDirectory(context);
        if (overlay.getResource() == null) {
            return null;
        }
        String name = overlay.getResource().getName();
        if (name.endsWith("!/")) {
            name = name.substring(0, name.length() - 2);
        }
        if ((i = name.lastIndexOf(47)) > 0) {
            name = name.substring(i + 1, name.length());
        }
        name = name.replace('.', '_');
        name = name + ++COUNTER;
        File unpackDir = dir = new File(context.getTempDirectory(), name);
        if (overlay.getConfig() != null && overlay.getConfig().getTargetPath() != null) {
            unpackDir = new File(dir, overlay.getConfig().getTargetPath());
        }
        overlay.getResource().copyTo(unpackDir);
        Resource unpackedOverlay = Resource.newResource((String)dir.getCanonicalPath());
        LOG.info("Unpacked overlay: " + overlay + " to " + unpackedOverlay, new Object[0]);
        return unpackedOverlay;
    }
}

