/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.net.URI;
import org.eclipse.jetty.annotations.AbstractDiscoverableAnnotationHandler;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.maven.plugin.JettyWebAppContext;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.WebAppContext;

public class MavenAnnotationConfiguration
extends AnnotationConfiguration {
    private static final Logger LOG = Log.getLogger(MavenAnnotationConfiguration.class);

    public void parseWebInfClasses(WebAppContext context, AnnotationParser parser) throws Exception {
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (jwac.getClassPathFiles() == null || jwac.getClassPathFiles().size() == 0) {
            super.parseWebInfClasses(context, parser);
        } else {
            Resource classesDir;
            LOG.debug("Scanning classes ", new Object[0]);
            MetaData metaData = context.getMetaData();
            if (metaData == null) {
                throw new IllegalStateException("No metadata");
            }
            parser.clearHandlers();
            for (AnnotationParser.DiscoverableAnnotationHandler h : this._discoverableAnnotationHandlers) {
                if (!(h instanceof AbstractDiscoverableAnnotationHandler)) continue;
                ((AbstractDiscoverableAnnotationHandler)h).setResource(null);
            }
            parser.registerHandlers(this._discoverableAnnotationHandlers);
            parser.registerHandler((AnnotationParser.Handler)this._classInheritanceHandler);
            parser.registerHandlers(this._containerInitializerAnnotationHandlers);
            for (File f : jwac.getClassPathFiles()) {
                if (!f.isDirectory() || !f.exists()) continue;
                this.doParse(context, parser, Resource.newResource((URI)f.toURI()));
            }
            if (context.getWebInf() != null && context.getWebInf().exists() && (classesDir = context.getWebInf().addPath("classes/")).exists()) {
                this.doParse(context, parser, classesDir);
            }
        }
    }

    public void doParse(final WebAppContext context, AnnotationParser parser, Resource resource) throws Exception {
        parser.parseDir(resource, new ClassNameResolver(){

            public boolean isExcluded(String name) {
                if (context.isSystemClass(name)) {
                    return true;
                }
                if (context.isServerClass(name)) {
                    return false;
                }
                return false;
            }

            public boolean shouldOverride(String name) {
                return !context.isParentLoaderPriority();
            }
        });
    }
}

