/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.util.EventListener;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.jetty.maven.plugin.AbstractJettyMojo;
import org.eclipse.jetty.util.PathWatcher;

public class JettyRunWarExplodedMojo
extends AbstractJettyMojo {
    private File war;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }

    @Override
    public void finishConfigurationBeforeStart() throws Exception {
        this.server.setStopAtShutdown(true);
        super.finishConfigurationBeforeStart();
    }

    @Override
    public void checkPackagingConfiguration() throws MojoExecutionException {
        if (!"war".equals(this.project.getPackaging())) {
            throw new MojoExecutionException("Not war packaging");
        }
    }

    @Override
    public void checkPomConfiguration() throws MojoExecutionException {
    }

    @Override
    public void configureScanner() throws MojoExecutionException {
        File lib;
        File classes;
        File jettyEnvXmlFile;
        File jettyWebXmlFile;
        this.scanner.watch(this.project.getFile().toPath());
        File webInfDir = new File(this.war, "WEB-INF");
        File webXml = new File(webInfDir, "web.xml");
        if (webXml.exists()) {
            this.scanner.watch(webXml.toPath());
        }
        if ((jettyWebXmlFile = this.findJettyWebXmlFile(webInfDir)) != null) {
            this.scanner.watch(jettyWebXmlFile.toPath());
        }
        if ((jettyEnvXmlFile = new File(webInfDir, "jetty-env.xml")).exists()) {
            this.scanner.watch(jettyEnvXmlFile.toPath());
        }
        if ((classes = new File(webInfDir, "classes")).exists()) {
            PathWatcher.Config classesConfig = new PathWatcher.Config(classes.toPath());
            classesConfig.setRecurseDepth(-9999);
            this.scanner.watch(classesConfig);
        }
        if ((lib = new File(webInfDir, "lib")).exists()) {
            PathWatcher.Config libConfig = new PathWatcher.Config(lib.toPath());
            libConfig.setRecurseDepth(-9999);
            this.scanner.watch(libConfig);
        }
        this.scanner.addListener((EventListener)new PathWatcher.EventListListener(){

            public void onPathWatchEvents(List<PathWatcher.PathWatchEvent> events) {
                try {
                    boolean reconfigure = false;
                    for (PathWatcher.PathWatchEvent e : events) {
                        if (!e.getPath().equals(JettyRunWarExplodedMojo.this.project.getFile().toPath())) continue;
                        reconfigure = true;
                        break;
                    }
                    JettyRunWarExplodedMojo.this.restartWebApp(reconfigure);
                }
                catch (Exception e) {
                    JettyRunWarExplodedMojo.this.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void restartWebApp(boolean reconfigureScanner) throws Exception {
        this.getLog().info((CharSequence)"Restarting webapp");
        this.getLog().debug((CharSequence)"Stopping webapp ...");
        this.stopScanner();
        this.webApp.stop();
        this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
        this.checkPomConfiguration();
        if (reconfigureScanner) {
            this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
            this.scanner.reset();
            this.configureScanner();
        }
        this.getLog().debug((CharSequence)"Restarting webapp ...");
        this.webApp.start();
        this.startScanner();
        this.getLog().info((CharSequence)"Restart completed.");
    }

    @Override
    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        this.webApp.setWar(this.war.getCanonicalPath());
    }
}

