/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jetty.maven.AbstractJettyEmbedder;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractForkedChild
extends ContainerLifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractForkedChild.class);
    protected AbstractJettyEmbedder jetty = this.newJettyEmbedder();
    protected File tokenFile;
    protected Scanner scanner;
    protected File webAppPropsFile;
    protected int scanInterval;

    public AbstractForkedChild(String[] args) throws Exception {
        this.configure(args);
    }

    public AbstractJettyEmbedder getJettyEmbedder() {
        return this.jetty;
    }

    protected abstract AbstractJettyEmbedder newJettyEmbedder();

    public void configure(String[] args) throws Exception {
        HashMap<String, String> jettyProperties = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            if ("--stop-port".equals(args[i])) {
                this.jetty.setStopPort(Integer.parseInt(args[++i]));
                continue;
            }
            if ("--stop-key".equals(args[i])) {
                this.jetty.setStopKey(args[++i]);
                continue;
            }
            if ("--jetty-xml".equals(args[i])) {
                ArrayList<File> jettyXmls = new ArrayList<File>();
                String[] names = StringUtil.csvSplit((String)args[++i]);
                for (int j = 0; names != null && j < names.length; ++j) {
                    jettyXmls.add(new File(names[j].trim()));
                }
                this.jetty.setJettyXmlFiles(jettyXmls);
                continue;
            }
            if ("--webprops".equals(args[i])) {
                this.webAppPropsFile = new File(args[++i].trim());
                this.jetty.setWebAppProperties(this.loadWebAppProps());
                continue;
            }
            if ("--token".equals(args[i])) {
                this.tokenFile = new File(args[++i].trim());
                continue;
            }
            if ("--scanInterval".equals(args[i])) {
                this.scanInterval = Integer.parseInt(args[++i].trim());
                this.scanner = new Scanner();
                this.scanner.setReportExistingFilesOnStartup(false);
                this.scanner.setScanInterval(this.scanInterval);
                this.scanner.addListener((Scanner.Listener)new Scanner.BulkListener(){

                    public void filesChanged(Set<String> changes) {
                        if (!Objects.isNull(AbstractForkedChild.this.scanner)) {
                            try {
                                AbstractForkedChild.this.scanner.stop();
                                AbstractForkedChild.this.jetty.redeployWebApp(AbstractForkedChild.this.loadWebAppProps());
                                AbstractForkedChild.this.scanner.start();
                            }
                            catch (Exception e) {
                                LOG.error("Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                            }
                        }
                    }
                });
                if (Objects.isNull(this.webAppPropsFile)) continue;
                this.scanner.addFile(this.webAppPropsFile.toPath());
                continue;
            }
            String[] tmp = args[i].trim().split("=");
            if (tmp.length != 2) continue;
            jettyProperties.put(tmp[0], tmp[1]);
        }
        this.jetty.setJettyProperties(jettyProperties);
        this.jetty.setExitVm(true);
    }

    protected Properties loadWebAppProps() throws FileNotFoundException, IOException {
        Properties props = new Properties();
        if (Objects.nonNull(this.webAppPropsFile)) {
            props.load(new FileInputStream(this.webAppPropsFile));
        }
        return props;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.jetty.start();
        Path tokenPath = this.tokenFile.toPath();
        Files.createFile(tokenPath, new FileAttribute[0]);
        if (this.scanner != null) {
            this.scanner.start();
        }
        this.jetty.join();
    }
}

