/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.maven.AbstractForker;
import org.eclipse.jetty.maven.PluginLog;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public abstract class AbstractHomeForker
extends AbstractForker {
    protected String contextXml;
    protected File jettyHome;
    protected File jettyHomeZip;
    protected File jettyBase;
    protected File baseDir;
    protected String[] modules;
    protected String jettyOptions;
    protected List<File> libExtJarFiles;
    protected Path modulesPath;
    protected Path etcPath;
    protected Path libPath;
    protected Path webappPath;
    protected Path mavenLibPath;
    protected String version;
    protected String environment;

    public void setVersion(String version) {
        this.version = version;
    }

    public void setJettyOptions(String jettyOptions) {
        this.jettyOptions = jettyOptions;
    }

    public String getJettyOptions() {
        return this.jettyOptions;
    }

    public List<File> getLibExtJarFiles() {
        return this.libExtJarFiles;
    }

    public void setLibExtJarFiles(List<File> libExtJarFiles) {
        this.libExtJarFiles = libExtJarFiles;
    }

    public File getJettyHome() {
        return this.jettyHome;
    }

    public void setJettyHome(File jettyHome) {
        this.jettyHome = jettyHome;
    }

    public File getJettyBase() {
        return this.jettyBase;
    }

    public void setJettyBase(File jettyBase) {
        this.jettyBase = jettyBase;
    }

    public String[] getModules() {
        return this.modules;
    }

    public void setModules(String[] modules) {
        this.modules = modules;
    }

    public String getContextXmlFile() {
        return this.contextXml;
    }

    public void setContextXml(String contextXml) {
        this.contextXml = contextXml;
    }

    public File getJettyHomeZip() {
        return this.jettyHomeZip;
    }

    public void setJettyHomeZip(File jettyHomeZip) {
        this.jettyHomeZip = jettyHomeZip;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    protected ProcessBuilder createCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("java");
        if (StringUtil.isNotBlank((String)this.jvmArgs)) {
            Arrays.stream(this.jvmArgs.split(" ")).filter(a -> StringUtil.isNotBlank((String)a)).forEach(a -> cmd.add(a.trim()));
        }
        cmd.add("-jar");
        cmd.add(new File(this.jettyHome, "start.jar").getAbsolutePath());
        if (this.systemProperties != null) {
            for (Map.Entry entry : this.systemProperties.entrySet()) {
                cmd.add("-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
            }
        }
        cmd.add("-DSTOP.PORT=" + this.stopPort);
        if (this.stopKey != null) {
            cmd.add("-DSTOP.KEY=" + this.stopKey);
        }
        StringBuilder tmp = new StringBuilder();
        tmp.append("--module=");
        tmp.append("server,http," + this.environment + "-webapp," + this.environment + "-deploy");
        if (this.modules != null) {
            for (String m : this.modules) {
                if (tmp.indexOf(m) >= 0) continue;
                tmp.append("," + m);
            }
        }
        if (this.libExtJarFiles != null && !this.libExtJarFiles.isEmpty() && tmp.indexOf("ext") < 0) {
            tmp.append(",ext");
        }
        tmp.append("," + this.environment + "-maven");
        cmd.add(tmp.toString());
        if (StringUtil.isNotBlank((String)this.jettyOptions)) {
            Arrays.stream(this.jettyOptions.split(" ")).filter(a -> StringUtil.isNotBlank((String)a)).forEach(a -> cmd.add(a.trim()));
        }
        if (this.jettyProperties != null) {
            for (Map.Entry entry : this.jettyProperties.entrySet()) {
                cmd.add((String)entry.getKey() + "=" + (String)entry.getValue());
            }
        }
        cmd.add("jetty.token.file=" + this.tokenFile.getAbsolutePath().toString());
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        processBuilder.directory(this.workDir);
        PluginLog.getLog().info((CharSequence)"Home process starting");
        if (!this.env.isEmpty()) {
            processBuilder.environment().putAll(this.env);
        }
        if (this.waitForChild) {
            processBuilder.inheritIO();
        } else {
            processBuilder.redirectOutput(this.jettyOutputFile);
            processBuilder.redirectErrorStream(true);
        }
        return processBuilder;
    }

    @Override
    public void doStart() throws Exception {
        this.configureJettyHome();
        if (this.jettyHome == null || !this.jettyHome.exists()) {
            throw new IllegalStateException("No jetty home");
        }
        this.configureJettyBase();
        this.generateWebAppPropertiesFile();
        super.doStart();
    }

    @Override
    protected void redeployWebApp() throws Exception {
        this.generateWebAppPropertiesFile();
        this.webappPath.resolve("maven.xml").toFile().setLastModified(System.currentTimeMillis());
    }

    protected abstract void generateWebAppPropertiesFile() throws Exception;

    private void configureJettyBase() throws Exception {
        if (this.jettyBase != null && !this.jettyBase.exists()) {
            throw new IllegalStateException(this.jettyBase.getAbsolutePath() + " does not exist");
        }
        File targetJettyBase = new File(this.baseDir, "jetty-base");
        final Path targetBasePath = targetJettyBase.toPath();
        if (Files.exists(targetBasePath, new LinkOption[0])) {
            IO.delete((File)targetJettyBase);
        }
        targetJettyBase.mkdirs();
        this.workDir = targetJettyBase;
        if (this.jettyBase != null) {
            final Path jettyBasePath = this.jettyBase.toPath();
            final File contextXmlFile = this.contextXml == null ? null : FileSystems.getDefault().getPath(this.contextXml, new String[0]).toFile();
            Files.walkFileTree(jettyBasePath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){
                final /* synthetic */ AbstractHomeForker this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    block2: {
                        Path targetDir = targetBasePath.resolve(jettyBasePath.relativize(dir));
                        try {
                            Files.copy(dir, targetDir, new CopyOption[0]);
                        }
                        catch (FileAlreadyExistsException e) {
                            if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                            throw e;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (contextXmlFile != null && Files.isSameFile(contextXmlFile.toPath(), file)) {
                        return FileVisitResult.CONTINUE;
                    }
                    Files.copy(file, targetBasePath.resolve(jettyBasePath.relativize(file)), new CopyOption[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        this.modulesPath = Files.createDirectories(targetBasePath.resolve("modules"), new FileAttribute[0]);
        this.etcPath = Files.createDirectories(targetBasePath.resolve("etc"), new FileAttribute[0]);
        this.libPath = Files.createDirectories(targetBasePath.resolve("lib"), new FileAttribute[0]);
        this.webappPath = Files.createDirectories(targetBasePath.resolve("webapps"), new FileAttribute[0]);
        this.mavenLibPath = Files.createDirectories(this.libPath.resolve(this.environment + "-maven"), new FileAttribute[0]);
        URI thisJar = TypeUtil.getLocationOfClass(((Object)((Object)this)).getClass());
        if (thisJar == null) {
            throw new IllegalStateException("Can't find jar for jetty-" + this.environment + "-maven-plugin");
        }
        try (InputStream jarStream = thisJar.toURL().openStream();
             FileOutputStream fileStream = new FileOutputStream(this.mavenLibPath.resolve("jetty-" + this.environment + "-maven-plugin.jar").toFile());){
            IO.copy((InputStream)jarStream, (OutputStream)fileStream);
        }
        URI commonJar = TypeUtil.getLocationOfClass(AbstractHomeForker.class);
        if (commonJar == null) {
            throw new IllegalStateException("Can't find jar for jetty-maven common classes");
        }
        try (InputStream jarStream = commonJar.toURL().openStream();
             FileOutputStream fileStream = new FileOutputStream(this.mavenLibPath.resolve("jetty-maven.jar").toFile());){
            IO.copy((InputStream)jarStream, (OutputStream)fileStream);
        }
        String mavenXml = "maven-" + this.environment + ".xml";
        try (InputStream mavenXmlStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(mavenXml);
             FileOutputStream fileStream = new FileOutputStream(this.webappPath.resolve(mavenXml).toFile());){
            IO.copy((InputStream)mavenXmlStream, (OutputStream)fileStream);
        }
        Files.writeString(this.webappPath.resolve("maven-" + this.environment + ".properties"), (CharSequence)("environment=" + this.environment), new OpenOption[0]);
        String mavenMod = this.environment + "-maven.mod";
        try (InputStream mavenModStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(mavenMod);
             FileOutputStream fileStream = new FileOutputStream(this.modulesPath.resolve(mavenMod).toFile());){
            IO.copy((InputStream)mavenModStream, (OutputStream)fileStream);
        }
        String jettyMavenXml = "jetty-" + this.environment + "-maven.xml";
        try (InputStream jettyMavenStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(jettyMavenXml);
             FileOutputStream fileStream = new FileOutputStream(this.etcPath.resolve(jettyMavenXml).toFile());){
            IO.copy((InputStream)jettyMavenStream, (OutputStream)fileStream);
        }
        if (this.libExtJarFiles != null && !this.libExtJarFiles.isEmpty()) {
            Path libExtPath = Files.createDirectories(this.libPath.resolve("ext"), new FileAttribute[0]);
            for (File f : this.libExtJarFiles) {
                try (FileInputStream jarStream = new FileInputStream(f);
                     FileOutputStream fileStream = new FileOutputStream(libExtPath.resolve(f.getName()).toFile());){
                    IO.copy((InputStream)jarStream, (OutputStream)fileStream);
                }
            }
        }
    }

    private void configureJettyHome() throws Exception {
        if (this.jettyHome == null && this.jettyHomeZip == null) {
            throw new IllegalStateException("No jettyHome");
        }
        if (this.baseDir == null) {
            throw new IllegalStateException("No baseDir");
        }
        if (this.jettyHome == null) {
            try (ResourceFactory.Closeable resourceFactory = ResourceFactory.closeable();){
                Resource res = resourceFactory.newJarFileResource(this.jettyHomeZip.toPath().toUri());
                res.copyTo(this.baseDir.toPath());
            }
            this.jettyHome = new File(this.baseDir, "jetty-home-" + this.version);
        }
    }
}

