/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.eclipse.jetty.maven.Overlay;
import org.eclipse.jetty.maven.OverlayConfig;
import org.eclipse.jetty.maven.SelectiveJarResource;
import org.eclipse.jetty.maven.WarPluginInfo;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.MountedPathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class OverlayManager {
    private final WarPluginInfo warPlugin;

    public OverlayManager(WarPluginInfo warPlugin) {
        this.warPlugin = warPlugin;
    }

    public void applyOverlays(ContextHandler contextHandler, boolean append) throws Exception {
        ArrayList<Resource> resourceBases = new ArrayList<Resource>();
        for (Overlay o : this.getOverlays(contextHandler)) {
            if (o.getConfig() != null && o.getConfig().isCurrentProject() && contextHandler.getBaseResource().exists()) {
                resourceBases.add(contextHandler.getBaseResource());
                continue;
            }
            resourceBases.add(this.unpackOverlay(contextHandler, o));
        }
        if (!resourceBases.contains(contextHandler.getBaseResource()) && contextHandler.getBaseResource().exists()) {
            if (append) {
                resourceBases.add(0, contextHandler.getBaseResource());
            } else {
                resourceBases.add(contextHandler.getBaseResource());
            }
        }
        contextHandler.setBaseResource(ResourceFactory.combine(resourceBases));
    }

    private List<Overlay> getOverlays(ContextHandler contextHandler) throws Exception {
        Objects.requireNonNull(contextHandler);
        HashSet<Artifact> matchedWarArtifacts = new HashSet<Artifact>();
        ArrayList<Overlay> overlays = new ArrayList<Overlay>();
        for (OverlayConfig config : this.warPlugin.getMavenWarOverlayConfigs()) {
            if (config.isSkip()) continue;
            if (config.isCurrentProject()) {
                Overlay overlay = new Overlay(config, null);
                overlays.add(overlay);
                continue;
            }
            Artifact a = this.warPlugin.getWarArtifact(config.getGroupId(), config.getArtifactId(), config.getClassifier());
            if (a == null) continue;
            matchedWarArtifacts.add(a);
            Resource resource = ResourceFactory.of((Container)contextHandler).newJarFileResource(a.getFile().toPath().toUri());
            SelectiveJarResource r = new SelectiveJarResource(resource);
            r.setIncludes(config.getIncludes());
            r.setExcludes(config.getExcludes());
            Overlay overlay = new Overlay(config, r);
            overlays.add(overlay);
        }
        for (Artifact a : this.warPlugin.getWarArtifacts()) {
            if (matchedWarArtifacts.contains(a)) continue;
            Resource resource = ResourceFactory.of((Container)contextHandler).newJarFileResource(a.getFile().toPath().toUri());
            Overlay overlay = new Overlay(null, resource);
            overlays.add(overlay);
        }
        return overlays;
    }

    protected Resource unpackOverlay(ContextHandler contextHandler, Overlay overlay) throws IOException {
        File dir;
        Objects.requireNonNull(contextHandler);
        Objects.requireNonNull(overlay);
        if (overlay.getResource() == null) {
            return null;
        }
        assert (overlay.getResource() instanceof MountedPathResource);
        Path p = Paths.get(URIUtil.unwrapContainer((URI)overlay.getResource().getURI()));
        String name = p.getName(p.getNameCount() - 1).toString();
        name = name.replace('.', '_');
        File overlaysDir = new File(this.warPlugin.getProject().getBuild().getDirectory(), "jetty_overlays");
        File unpackDir = dir = new File(overlaysDir, name);
        if (overlay.getConfig() != null && overlay.getConfig().getTargetPath() != null) {
            unpackDir = new File(dir, overlay.getConfig().getTargetPath());
        }
        overlay.unpackTo(unpackDir);
        return ResourceFactory.of((Container)contextHandler).newResource(unpackDir.getCanonicalPath());
    }
}

