/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven;

import java.io.BufferedWriter;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;

public class ServerConnectorListener
extends AbstractLifeCycle.AbstractLifeCycleListener {
    private String _fileName;
    private String _sysPropertyName;

    public void lifeCycleStarted(LifeCycle event) {
        if (this.getFileName() != null) {
            try {
                Path tmp = Files.createTempFile("jettyport", ".tmp", new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(tmp, new OpenOption[0]);){
                    writer.write(String.valueOf(((ServerConnector)event).getLocalPort()));
                }
                Path path = Paths.get(this.getFileName(), new String[0]);
                Files.deleteIfExists(path);
                try {
                    Files.move(tmp, path, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (AtomicMoveNotSupportedException e) {
                    Files.move(tmp, path, new CopyOption[0]);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSysPropertyName() != null) {
            System.setProperty(this._sysPropertyName, String.valueOf(((ServerConnector)event).getLocalPort()));
        }
        super.lifeCycleStarted(event);
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String name) {
        this._fileName = name;
    }

    public String getSysPropertyName() {
        return this._sysPropertyName;
    }

    public void setSysPropertyName(String sysPropertyName) {
        this._sysPropertyName = sysPropertyName;
    }
}

