/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jetty.maven.AbstractForker;
import org.eclipse.jetty.maven.PluginLog;
import org.eclipse.jetty.server.Server;

public abstract class AbstractServerForker
extends AbstractForker {
    protected File forkWebXml;
    protected Server server;
    protected String containerClassPath;
    protected File webAppPropsFile;
    protected String contextXml;
    protected int scanInterval;
    protected String executionClassName;

    protected AbstractServerForker(String javaPath) {
        super(javaPath);
    }

    public boolean isScan() {
        return this.scanInterval > 0;
    }

    public void setScan(boolean scan) {
        this.setScanInterval(scan ? 1 : 0);
    }

    public int getScanInterval() {
        return this.scanInterval;
    }

    public void setScanInterval(int sec) {
        this.scanInterval = sec;
    }

    public File getWebAppPropsFile() {
        return this.webAppPropsFile;
    }

    public void setWebAppPropsFile(File webAppPropsFile) {
        this.webAppPropsFile = webAppPropsFile;
    }

    public File getForkWebXml() {
        return this.forkWebXml;
    }

    public void setForkWebXml(File forkWebXml) {
        this.forkWebXml = forkWebXml;
    }

    public String getContextXml() {
        return this.contextXml;
    }

    public void setContextXml(String contextXml) {
        this.contextXml = contextXml;
    }

    public String getContainerClassPath() {
        return this.containerClassPath;
    }

    public void setContainerClassPath(String containerClassPath) {
        this.containerClassPath = containerClassPath;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    @Override
    public void doStart() throws Exception {
        this.generateWebApp();
        super.doStart();
    }

    protected abstract void generateWebApp() throws Exception;

    @Override
    protected abstract void redeployWebApp() throws Exception;

    /*
     * WARNING - void declaration
     */
    @Override
    public ProcessBuilder createCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getJavaBin());
        if (this.jvmArgs != null) {
            void var3_4;
            String[] args = this.jvmArgs.split(" ");
            boolean bl = false;
            while (args != null && var3_4 < args.length) {
                if (args[var3_4] != null && !"".equals(args[var3_4])) {
                    cmd.add(((String)args[var3_4]).trim());
                }
                ++var3_4;
            }
        }
        if (this.systemProperties != null) {
            for (Map.Entry entry : this.systemProperties.entrySet()) {
                cmd.add("-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
            }
        }
        if (this.containerClassPath != null && this.containerClassPath.length() > 0) {
            cmd.add("-cp");
            cmd.add(this.containerClassPath);
        }
        cmd.add(this.executionClassName);
        if (this.stopPort > 0 && this.stopKey != null) {
            cmd.add("--stop-port");
            cmd.add(Integer.toString(this.stopPort));
            cmd.add("--stop-key");
            cmd.add(this.stopKey);
        }
        if (this.jettyXmlFiles != null) {
            cmd.add("--jetty-xml");
            StringBuilder tmp = new StringBuilder();
            for (File jettyXml : this.jettyXmlFiles) {
                if (tmp.length() != 0) {
                    tmp.append(",");
                }
                tmp.append(jettyXml.getAbsolutePath());
            }
            cmd.add(tmp.toString());
        }
        cmd.add("--webprops");
        cmd.add(this.webAppPropsFile.getAbsolutePath());
        cmd.add("--token");
        cmd.add(this.tokenFile.getAbsolutePath());
        if (this.scanInterval > 0) {
            cmd.add("--scanInterval");
            cmd.add(Integer.toString(this.scanInterval));
        }
        if (this.jettyProperties != null) {
            for (Map.Entry entry : this.jettyProperties.entrySet()) {
                cmd.add((String)entry.getKey() + "=" + (String)entry.getValue());
            }
        }
        ProcessBuilder command = new ProcessBuilder(cmd);
        command.directory(this.workDir);
        if (PluginLog.getLog().isDebugEnabled()) {
            PluginLog.getLog().debug((CharSequence)("Forked cli:" + String.valueOf(command.command())));
        }
        PluginLog.getLog().info((CharSequence)"Forked process starting");
        if (this.env != null && !this.env.isEmpty()) {
            command.environment().putAll(this.env);
        }
        if (this.waitForChild) {
            command.inheritIO();
        } else {
            command.redirectOutput(this.jettyOutputFile);
            command.redirectErrorStream(true);
        }
        return command;
    }
}

