/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.maven.MavenServerConnector;
import org.eclipse.jetty.maven.PluginLog;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.xml.XmlConfiguration;

public class ServerSupport {
    public static void configureHandlers(Server server, List<ContextHandler> contextHandlers, RequestLog requestLog) throws Exception {
        ContextHandlerCollection contexts;
        if (server == null) {
            throw new IllegalArgumentException("Server is null");
        }
        if (requestLog != null) {
            server.setRequestLog(requestLog);
        }
        if (server.getDefaultHandler() == null) {
            server.setDefaultHandler((Handler)new DefaultHandler());
        }
        if ((contexts = ServerSupport.findContextHandlerCollection(server)) == null) {
            contexts = new ContextHandlerCollection(new ContextHandler[0]);
            if (server.getHandler() != null) {
                Handler.Sequence handlers = new Handler.Sequence(new Handler[0]);
                handlers.addHandler(server.getHandler());
                handlers.addHandler((Handler)contexts);
                server.setHandler((Handler)handlers);
            } else {
                server.setHandler((Handler)contexts);
            }
        }
        if (contextHandlers != null) {
            for (ContextHandler context : contextHandlers) {
                contexts.addHandler((Handler)context);
            }
        }
    }

    public static void configureConnectors(Server server, Connector connector, Map<String, String> properties) {
        if (server == null) {
            throw new IllegalArgumentException("Server is null");
        }
        if (connector != null) {
            server.addConnector(connector);
            return;
        }
        Connector[] connectors = server.getConnectors();
        if (connectors == null || connectors.length == 0) {
            MavenServerConnector tmp = new MavenServerConnector();
            String port = System.getProperty(MavenServerConnector.PORT_SYSPROPERTY);
            if (port == null) {
                port = System.getProperty("jetty.port");
            }
            if (port == null) {
                String string = port = properties != null ? properties.get(MavenServerConnector.PORT_SYSPROPERTY) : null;
            }
            if (port == null) {
                port = MavenServerConnector.DEFAULT_PORT_STR;
            }
            tmp.setPort(Integer.parseInt(port.trim()));
            tmp.setServer(server);
            server.setConnectors(new Connector[]{tmp});
        }
    }

    public static void configureLoginServices(Server server, List<LoginService> loginServices) {
        if (server == null) {
            throw new IllegalArgumentException("Server is null");
        }
        if (loginServices != null) {
            for (LoginService loginService : loginServices) {
                PluginLog.getLog().debug((CharSequence)(loginService.getClass().getName() + ": " + loginService.toString()));
                server.addBean((Object)loginService);
            }
        }
    }

    public static void addWebApplication(Server server, ContextHandler webapp) throws Exception {
        if (server == null) {
            throw new IllegalArgumentException("Server is null");
        }
        ContextHandlerCollection contexts = ServerSupport.findContextHandlerCollection(server);
        if (contexts == null) {
            throw new IllegalStateException("ContextHandlerCollection is null");
        }
        contexts.addHandler((Handler)webapp);
    }

    public static ContextHandlerCollection findContextHandlerCollection(Server server) {
        if (server == null) {
            return null;
        }
        return (ContextHandlerCollection)server.getDescendant(ContextHandlerCollection.class);
    }

    public static Server applyXmlConfigurations(Server server, List<File> files, Map<String, String> properties) throws Exception {
        if (files == null || files.isEmpty()) {
            return server;
        }
        Map<String, Object> lastMap = new HashMap<String, Server>();
        if (server != null) {
            lastMap.put("Server", server);
        }
        for (File xmlFile : files) {
            if (PluginLog.getLog() != null) {
                PluginLog.getLog().info((CharSequence)("Configuring Jetty from xml configuration file = " + xmlFile.getCanonicalPath()));
            }
            XmlConfiguration xmlConfiguration = new XmlConfiguration(ResourceFactory.of((Container)server).newResource(xmlFile.toPath()));
            if (properties != null) {
                for (Map.Entry<String, String> e : properties.entrySet()) {
                    xmlConfiguration.getProperties().put(e.getKey(), e.getValue());
                }
            }
            if (lastMap != null) {
                xmlConfiguration.getIdMap().putAll(lastMap);
            }
            Enumeration<?> ensysprop = System.getProperties().propertyNames();
            while (ensysprop.hasMoreElements()) {
                String name = (String)ensysprop.nextElement();
                xmlConfiguration.getProperties().put(name, System.getProperty(name));
            }
            xmlConfiguration.configure();
            lastMap = xmlConfiguration.getIdMap();
        }
        return (Server)lastMap.get("Server");
    }

    public static Server applyXmlConfigurations(Server server, List<File> files) throws Exception {
        return ServerSupport.applyXmlConfigurations(server, files, null);
    }
}

