/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.maven.MavenServerConnector;
import org.eclipse.jetty.maven.ServerSupport;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ShutdownMonitor;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public abstract class AbstractJettyEmbedder
extends ContainerLifeCycle {
    protected List<ContextHandler> contextHandlers;
    protected List<LoginService> loginServices;
    protected RequestLog requestLog;
    protected MavenServerConnector httpConnector;
    protected Server server;
    protected boolean exitVm;
    protected boolean stopAtShutdown;
    protected List<File> jettyXmlFiles;
    protected Map<String, String> jettyProperties;
    protected ShutdownMonitor shutdownMonitor;
    protected int stopPort;
    protected String stopKey;
    protected String contextXml;
    protected Properties webAppProperties;

    public List<ContextHandler> getContextHandlers() {
        return this.contextHandlers;
    }

    public void setContextHandlers(List<ContextHandler> contextHandlers) {
        this.contextHandlers = contextHandlers == null ? null : new ArrayList<ContextHandler>(contextHandlers);
    }

    public List<LoginService> getLoginServices() {
        return this.loginServices;
    }

    public void setLoginServices(List<LoginService> loginServices) {
        this.loginServices = loginServices == null ? null : new ArrayList<LoginService>(loginServices);
    }

    public RequestLog getRequestLog() {
        return this.requestLog;
    }

    public void setRequestLog(RequestLog requestLog) {
        this.requestLog = requestLog;
    }

    public MavenServerConnector getHttpConnector() {
        return this.httpConnector;
    }

    public void setHttpConnector(MavenServerConnector httpConnector) {
        this.httpConnector = httpConnector;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public boolean isExitVm() {
        return this.exitVm;
    }

    public void setExitVm(boolean exitVm) {
        this.exitVm = exitVm;
    }

    public boolean isStopAtShutdown() {
        return this.stopAtShutdown;
    }

    public void setStopAtShutdown(boolean stopAtShutdown) {
        this.stopAtShutdown = stopAtShutdown;
    }

    public List<File> getJettyXmlFiles() {
        return this.jettyXmlFiles;
    }

    public void setJettyXmlFiles(List<File> jettyXmlFiles) {
        this.jettyXmlFiles = jettyXmlFiles;
    }

    public Map<String, String> getJettyProperties() {
        return this.jettyProperties;
    }

    public void setJettyProperties(Map<String, String> jettyProperties) {
        this.jettyProperties = jettyProperties;
    }

    public ShutdownMonitor getShutdownMonitor() {
        return this.shutdownMonitor;
    }

    public void setShutdownMonitor(ShutdownMonitor shutdownMonitor) {
        this.shutdownMonitor = shutdownMonitor;
    }

    public int getStopPort() {
        return this.stopPort;
    }

    public void setStopPort(int stopPort) {
        this.stopPort = stopPort;
    }

    public String getStopKey() {
        return this.stopKey;
    }

    public void setStopKey(String stopKey) {
        this.stopKey = stopKey;
    }

    public void setWebAppProperties(Properties props) {
        if (this.webAppProperties != null) {
            this.webAppProperties.clear();
        }
        if (props != null) {
            if (this.webAppProperties == null) {
                this.webAppProperties = new Properties();
            }
            this.webAppProperties.putAll((Map<?, ?>)props);
        }
    }

    public String getContextXml() {
        return this.contextXml;
    }

    public void setContextXml(String contextXml) {
        this.contextXml = contextXml;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.configure();
        this.configureShutdownMonitor();
        this.server.start();
    }

    protected abstract void redeployWebApp() throws Exception;

    public void redeployWebApp(Properties webaAppProperties) throws Exception {
        this.setWebAppProperties(webaAppProperties);
        this.redeployWebApp();
    }

    public abstract void stopWebApp() throws Exception;

    public void join() throws InterruptedException {
        this.server.join();
    }

    protected void configure() throws Exception {
        this.configureServer();
        this.configureWebApp();
        this.addWebAppToServer();
    }

    protected void configureServer() throws Exception {
        Server tmp = ServerSupport.applyXmlConfigurations(new Server(), this.jettyXmlFiles, this.jettyProperties);
        if (tmp != null) {
            this.server = tmp;
        }
        this.server.setStopAtShutdown(this.stopAtShutdown);
        if (this.httpConnector != null) {
            this.httpConnector.setServer(this.server);
        }
        ServerSupport.configureConnectors(this.server, this.httpConnector, this.jettyProperties);
        ServerSupport.configureHandlers(this.server, this.contextHandlers, this.requestLog);
        ServerSupport.configureLoginServices(this.server, this.loginServices);
    }

    protected abstract void configureWebApp() throws Exception;

    protected abstract void addWebAppToServer() throws Exception;

    protected void applyWebAppProperties() throws Exception {
        if (this.contextXml != null) {
            if (this.webAppProperties == null) {
                this.webAppProperties = new Properties();
            }
            this.webAppProperties.put("context.xml", this.contextXml);
        }
    }

    private void configureShutdownMonitor() {
        if (this.stopPort > 0 && this.stopKey != null) {
            ShutdownMonitor monitor = ShutdownMonitor.getInstance();
            monitor.setPort(this.stopPort);
            monitor.setKey(this.stopKey);
            monitor.setExitVm(this.exitVm);
        }
    }
}

