/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jetty.plus.annotation.Injection;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionCollection {
    public static final String INJECTION_COLLECTION = "org.eclipse.jetty.injectionCollection";
    private HashMap<Class<?>, List<Injection>> fieldInjectionsMap = new HashMap();
    private HashMap<Class<?>, List<Injection>> methodInjectionsMap = new HashMap();

    public void add(Injection injection) {
        ArrayList<Injection> injections;
        if (injection == null || injection.getTarget() == null || injection.getTargetClass() == null) {
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Adding injection for class=" + injection.getTargetClass() + " on a " + injection.getTarget()));
        }
        HashMap<Class<?>, List<Injection>> injectionsMap = null;
        if (injection.getTarget() instanceof Field) {
            injectionsMap = this.fieldInjectionsMap;
        }
        if (injection.getTarget() instanceof Method) {
            injectionsMap = this.methodInjectionsMap;
        }
        if ((injections = (ArrayList<Injection>)injectionsMap.get(injection.getTargetClass())) == null) {
            injections = new ArrayList<Injection>();
            injectionsMap.put(injection.getTargetClass(), injections);
        }
        injections.add(injection);
    }

    public List<Injection> getFieldInjections(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        List<Injection> list = this.fieldInjectionsMap.get(clazz);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public List<Injection> getMethodInjections(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        List<Injection> list = this.methodInjectionsMap.get(clazz);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public List<Injection> getInjections(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        ArrayList<Injection> results = new ArrayList<Injection>();
        results.addAll(this.getFieldInjections(clazz));
        results.addAll(this.getMethodInjections(clazz));
        return results;
    }

    public Injection getInjection(Class<?> clazz, Member member) {
        if (clazz == null) {
            return null;
        }
        if (member == null) {
            return null;
        }
        HashMap<Class<?>, List<Injection>> map = null;
        if (member instanceof Field) {
            map = this.fieldInjectionsMap;
        } else if (member instanceof Method) {
            map = this.methodInjectionsMap;
        }
        if (map == null) {
            return null;
        }
        List injections = (List)map.get(clazz);
        Injection injection = null;
        for (int i = 0; injections != null && i < injections.size() && injection == null; ++i) {
            Injection candidate = (Injection)injections.get(i);
            if (!candidate.getTarget().equals(member)) continue;
            injection = candidate;
        }
        return injection;
    }

    public void inject(Object injectable) throws Exception {
        if (injectable == null) {
            return;
        }
        for (Class<?> clazz = injectable.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            List<Injection> injections = this.getFieldInjections(clazz);
            for (Injection i : injections) {
                i.inject(injectable);
            }
            injections = this.getMethodInjections(clazz);
            for (Injection i : injections) {
                i.inject(injectable);
            }
        }
    }
}

