/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.proxy;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.WritePendingException;
import javax.servlet.ReadListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.DeferredContentProvider;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.eclipse.jetty.util.Callback;

public class AsyncProxyServlet
extends ProxyServlet {
    private static final String WRITE_LISTENER_ATTRIBUTE = AsyncProxyServlet.class.getName() + ".writeListener";

    @Override
    protected ContentProvider proxyRequestContent(Request proxyRequest, HttpServletRequest request) throws IOException {
        ServletInputStream input = request.getInputStream();
        DeferredContentProvider provider = new DeferredContentProvider(new ByteBuffer[0]);
        input.setReadListener((ReadListener)new StreamReader(proxyRequest, request, provider));
        return provider;
    }

    @Override
    protected void onResponseContent(HttpServletRequest request, HttpServletResponse response, Response proxyResponse, byte[] buffer, int offset, int length, Callback callback) {
        try {
            this._log.debug("{} proxying content to downstream: {} bytes", new Object[]{this.getRequestId(request), length});
            StreamWriter writeListener = (StreamWriter)request.getAttribute(WRITE_LISTENER_ATTRIBUTE);
            if (writeListener == null) {
                writeListener = new StreamWriter(request, proxyResponse);
                request.setAttribute(WRITE_LISTENER_ATTRIBUTE, (Object)writeListener);
                writeListener.data(buffer, offset, length, callback);
                response.getOutputStream().setWriteListener((WriteListener)writeListener);
            } else {
                writeListener.data(buffer, offset, length, callback);
                writeListener.onWritePossible();
            }
        }
        catch (Throwable x) {
            callback.failed(x);
            this.onResponseFailure(request, response, proxyResponse, x);
        }
    }

    private static enum WriteState {
        READY,
        PENDING,
        IDLE;

    }

    private class StreamWriter
    implements WriteListener {
        private final HttpServletRequest request;
        private final Response proxyResponse;
        private WriteState state;
        private byte[] buffer;
        private int offset;
        private int length;
        private Callback callback;

        private StreamWriter(HttpServletRequest request, Response proxyResponse) {
            this.request = request;
            this.proxyResponse = proxyResponse;
            this.state = WriteState.IDLE;
        }

        private void data(byte[] bytes, int offset, int length, Callback callback) {
            if (this.state != WriteState.IDLE) {
                throw new WritePendingException();
            }
            this.state = WriteState.READY;
            this.buffer = bytes;
            this.offset = offset;
            this.length = length;
            this.callback = callback;
        }

        public void onWritePossible() throws IOException {
            int requestId = AsyncProxyServlet.this.getRequestId(this.request);
            ServletOutputStream output = this.request.getAsyncContext().getResponse().getOutputStream();
            if (this.state == WriteState.READY) {
                AsyncProxyServlet.this._log.debug("{} asynchronous write start of {} bytes on {}", new Object[]{requestId, this.length, output});
                output.write(this.buffer, this.offset, this.length);
                this.state = WriteState.PENDING;
                if (output.isReady()) {
                    AsyncProxyServlet.this._log.debug("{} asynchronous write of {} bytes completed on {}", new Object[]{requestId, this.length, output});
                    this.complete();
                } else {
                    AsyncProxyServlet.this._log.debug("{} asynchronous write of {} bytes pending on {}", new Object[]{requestId, this.length, output});
                }
            } else if (this.state == WriteState.PENDING) {
                AsyncProxyServlet.this._log.debug("{} asynchronous write of {} bytes completing on {}", new Object[]{requestId, this.length, output});
                this.complete();
            } else {
                throw new IllegalStateException();
            }
        }

        private void complete() {
            this.buffer = null;
            this.offset = 0;
            this.length = 0;
            Callback c = this.callback;
            this.callback = null;
            this.state = WriteState.IDLE;
            c.succeeded();
        }

        public void onError(Throwable failure) {
            HttpServletResponse response = (HttpServletResponse)this.request.getAsyncContext().getResponse();
            AsyncProxyServlet.this.onResponseFailure(this.request, response, this.proxyResponse, failure);
        }
    }

    private class StreamReader
    implements ReadListener,
    Callback {
        private final byte[] buffer;
        private final Request proxyRequest;
        private final HttpServletRequest request;
        private final DeferredContentProvider provider;

        public StreamReader(Request proxyRequest, HttpServletRequest request, DeferredContentProvider provider) {
            this.buffer = new byte[AsyncProxyServlet.this.getHttpClient().getRequestBufferSize()];
            this.proxyRequest = proxyRequest;
            this.request = request;
            this.provider = provider;
        }

        public void onDataAvailable() throws IOException {
            int requestId = AsyncProxyServlet.this.getRequestId(this.request);
            ServletInputStream input = this.request.getInputStream();
            AsyncProxyServlet.this._log.debug("{} asynchronous read start on {}", new Object[]{requestId, input});
            while (input.isReady() && !input.isFinished()) {
                int read = input.read(this.buffer);
                AsyncProxyServlet.this._log.debug("{} asynchronous read {} bytes on {}", new Object[]{requestId, read, input});
                if (read <= 0) continue;
                AsyncProxyServlet.this._log.debug("{} proxying content to upstream: {} bytes", new Object[]{requestId, read});
                this.provider.offer(ByteBuffer.wrap(this.buffer, 0, read), (Callback)this);
                break;
            }
            if (!input.isFinished()) {
                AsyncProxyServlet.this._log.debug("{} asynchronous read pending on {}", new Object[]{requestId, input});
            }
        }

        public void onAllDataRead() throws IOException {
            AsyncProxyServlet.this._log.debug("{} proxying content to upstream completed", (long)AsyncProxyServlet.this.getRequestId(this.request));
            this.provider.close();
        }

        public void onError(Throwable x) {
            this.failed(x);
        }

        public void succeeded() {
            try {
                if (this.request.getInputStream().isReady()) {
                    this.onDataAvailable();
                }
            }
            catch (Throwable x) {
                this.failed(x);
            }
        }

        public void failed(Throwable x) {
            AsyncProxyServlet.this.onClientRequestFailure(this.proxyRequest, this.request, x);
        }
    }

    public static class Transparent
    extends AsyncProxyServlet {
        private final ProxyServlet.TransparentDelegate delegate = new ProxyServlet.TransparentDelegate(this);

        public void init(ServletConfig config) throws ServletException {
            super.init(config);
            this.delegate.init(config);
        }

        @Override
        protected URI rewriteURI(HttpServletRequest request) {
            return this.delegate.rewriteURI(request);
        }
    }
}

