/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.proxy.AbstractProxyServlet;
import org.eclipse.jetty.util.Callback;

public class ProxyServlet
extends AbstractProxyServlet {
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int requestId = this.getRequestId(request);
        URI rewrittenURI = this.rewriteURI(request);
        if (this._log.isDebugEnabled()) {
            StringBuffer uri = request.getRequestURL();
            if (request.getQueryString() != null) {
                uri.append("?").append(request.getQueryString());
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug("{} rewriting: {} -> {}", new Object[]{requestId, uri, rewrittenURI});
            }
        }
        if (rewrittenURI == null) {
            this.onRewriteFailed(request, response);
            return;
        }
        Request proxyRequest = this.getHttpClient().newRequest(rewrittenURI).method(request.getMethod()).version(HttpVersion.fromString((String)request.getProtocol()));
        this.copyHeaders(request, proxyRequest);
        this.addProxyHeaders(request, proxyRequest);
        AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(0L);
        proxyRequest.timeout(this.getTimeout(), TimeUnit.MILLISECONDS);
        if (this.hasContent(request)) {
            proxyRequest.content(this.proxyRequestContent(proxyRequest, request));
        }
        this.customizeProxyRequest(proxyRequest, request);
        this.sendProxyRequest(request, response, proxyRequest);
    }

    @Deprecated
    protected void copyHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
        this.copyRequestHeaders(clientRequest, proxyRequest);
    }

    protected ContentProvider proxyRequestContent(Request proxyRequest, HttpServletRequest request) throws IOException {
        return new ProxyInputStreamContentProvider(proxyRequest, request, (InputStream)request.getInputStream());
    }

    protected Response.Listener newProxyResponseListener(HttpServletRequest request, HttpServletResponse response) {
        return new ProxyResponseListener(request, response);
    }

    protected void onClientRequestFailure(Request proxyRequest, HttpServletRequest request, Throwable failure) {
        if (this._log.isDebugEnabled()) {
            this._log.debug(this.getRequestId(request) + " client request failure", failure);
        }
        proxyRequest.abort(failure);
    }

    @Deprecated
    protected void onRewriteFailed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.onProxyRewriteFailed(request, response);
    }

    @Deprecated
    protected void onResponseHeaders(HttpServletRequest request, HttpServletResponse response, Response proxyResponse) {
        this.onServerResponseHeaders(request, response, proxyResponse);
    }

    @Override
    protected String filterServerResponseHeader(HttpServletRequest clientRequest, Response serverResponse, String headerName, String headerValue) {
        return this.filterResponseHeader(clientRequest, headerName, headerValue);
    }

    protected void onResponseContent(HttpServletRequest request, HttpServletResponse response, Response proxyResponse, byte[] buffer, int offset, int length, Callback callback) {
        try {
            if (this._log.isDebugEnabled()) {
                this._log.debug("{} proxying content to downstream: {} bytes", new Object[]{this.getRequestId(request), length});
            }
            response.getOutputStream().write(buffer, offset, length);
            callback.succeeded();
        }
        catch (Throwable x) {
            callback.failed(x);
        }
    }

    @Deprecated
    protected void onResponseSuccess(HttpServletRequest request, HttpServletResponse response, Response proxyResponse) {
        this.onProxyResponseSuccess(request, response, proxyResponse);
    }

    @Deprecated
    protected void onResponseFailure(HttpServletRequest request, HttpServletResponse response, Response proxyResponse, Throwable failure) {
        this.onProxyResponseFailure(request, response, proxyResponse, failure);
    }

    @Deprecated
    protected URI rewriteURI(HttpServletRequest request) {
        String newTarget = this.rewriteTarget(request);
        return newTarget == null ? null : URI.create(newTarget);
    }

    @Deprecated
    protected void customizeProxyRequest(Request proxyRequest, HttpServletRequest request) {
    }

    @Deprecated
    protected String filterResponseHeader(HttpServletRequest request, String headerName, String headerValue) {
        return headerValue;
    }

    protected class ProxyInputStreamContentProvider
    extends InputStreamContentProvider {
        private final Request proxyRequest;
        private final HttpServletRequest request;

        protected ProxyInputStreamContentProvider(Request proxyRequest, HttpServletRequest request, InputStream input) {
            super(input);
            this.proxyRequest = proxyRequest;
            this.request = request;
        }

        public long getLength() {
            return this.request.getContentLength();
        }

        protected ByteBuffer onRead(byte[] buffer, int offset, int length) {
            if (ProxyServlet.this._log.isDebugEnabled()) {
                ProxyServlet.this._log.debug("{} proxying content to upstream: {} bytes", new Object[]{ProxyServlet.this.getRequestId(this.request), length});
            }
            return this.onRequestContent(this.proxyRequest, this.request, buffer, offset, length);
        }

        protected ByteBuffer onRequestContent(Request proxyRequest, HttpServletRequest request, byte[] buffer, int offset, int length) {
            return super.onRead(buffer, offset, length);
        }

        protected void onReadFailure(Throwable failure) {
            ProxyServlet.this.onClientRequestFailure(this.proxyRequest, this.request, failure);
        }
    }

    protected class ProxyResponseListener
    extends Response.Listener.Adapter {
        private final HttpServletRequest request;
        private final HttpServletResponse response;

        protected ProxyResponseListener(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public void onBegin(Response proxyResponse) {
            this.response.setStatus(proxyResponse.getStatus());
        }

        public void onHeaders(Response proxyResponse) {
            ProxyServlet.this.onResponseHeaders(this.request, this.response, proxyResponse);
        }

        public void onContent(final Response proxyResponse, ByteBuffer content, final Callback callback) {
            int offset;
            byte[] buffer;
            int length = content.remaining();
            if (content.hasArray()) {
                buffer = content.array();
                offset = content.arrayOffset();
            } else {
                buffer = new byte[length];
                content.get(buffer);
                offset = 0;
            }
            ProxyServlet.this.onResponseContent(this.request, this.response, proxyResponse, buffer, offset, length, new Callback(){

                public void succeeded() {
                    callback.succeeded();
                }

                public void failed(Throwable x) {
                    callback.failed(x);
                    proxyResponse.abort(x);
                }
            });
        }

        public void onComplete(Result result) {
            if (result.isSucceeded()) {
                ProxyServlet.this.onResponseSuccess(this.request, this.response, result.getResponse());
            } else {
                ProxyServlet.this.onResponseFailure(this.request, this.response, result.getResponse(), result.getFailure());
            }
            if (ProxyServlet.this._log.isDebugEnabled()) {
                ProxyServlet.this._log.debug("{} proxying complete", (long)ProxyServlet.this.getRequestId(this.request));
            }
        }
    }

    public static class Transparent
    extends ProxyServlet {
        private final AbstractProxyServlet.TransparentDelegate delegate = new AbstractProxyServlet.TransparentDelegate(this);

        public void init(ServletConfig config) throws ServletException {
            super.init(config);
            this.delegate.init(config);
        }

        @Override
        protected URI rewriteURI(HttpServletRequest request) {
            return URI.create(this.delegate.rewriteTarget(request));
        }
    }
}

