/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quickstart;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.annotations.AnnotationDecorator;
import org.eclipse.jetty.annotations.ServletContainerInitializersStarter;
import org.eclipse.jetty.quickstart.QuickStartDescriptorProcessor;
import org.eclipse.jetty.quickstart.QuickStartGeneratorConfiguration;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.DescriptorProcessor;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.StandardDescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public class QuickStartConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(QuickStartConfiguration.class);
    public static final Set<Class<? extends Configuration>> __replacedConfigurations = new HashSet<Class<? extends Configuration>>();
    public static final String ORIGIN_ATTRIBUTE = "org.eclipse.jetty.quickstart.ORIGIN_ATTRIBUTE";
    public static final String GENERATE_ORIGIN = "org.eclipse.jetty.quickstart.GENERATE_ORIGIN";
    public static final String QUICKSTART_WEB_XML = "org.eclipse.jetty.quickstart.QUICKSTART_WEB_XML";
    private Mode _mode = Mode.AUTO;
    private boolean _quickStart;

    public QuickStartConfiguration() {
        super(true);
        this.addDependencies(new Class[]{WebInfConfiguration.class});
        this.addDependents(new Class[]{WebXmlConfiguration.class});
    }

    public void setMode(Mode mode) {
        this._mode = mode;
    }

    public Mode getMode() {
        return this._mode;
    }

    public void preConfigure(WebAppContext context) throws Exception {
        String war = context.getWar();
        if (war == null || war.length() <= 0 || !context.getBaseResource().isDirectory()) {
            throw new IllegalStateException("Bad Quickstart location");
        }
        Resource quickStartWebXml = this.getQuickStartWebXml(context);
        LOG.debug("quickStartWebXml={} exists={}", new Object[]{quickStartWebXml, quickStartWebXml.exists()});
        this._quickStart = false;
        switch (this._mode) {
            case DISABLED: {
                super.preConfigure(context);
                break;
            }
            case GENERATE: {
                super.preConfigure(context);
                QuickStartGeneratorConfiguration generator = new QuickStartGeneratorConfiguration(true);
                this.configure(generator, context);
                context.addConfiguration(new Configuration[]{generator});
                break;
            }
            case AUTO: {
                if (quickStartWebXml.exists()) {
                    this.quickStart(context, quickStartWebXml);
                    break;
                }
                super.preConfigure(context);
                QuickStartGeneratorConfiguration generator = new QuickStartGeneratorConfiguration(false);
                this.configure(generator, context);
                context.addConfiguration(new Configuration[]{generator});
                break;
            }
            case QUICKSTART: {
                if (quickStartWebXml.exists()) {
                    this.quickStart(context, quickStartWebXml);
                    break;
                }
                throw new IllegalStateException("No " + quickStartWebXml);
            }
            default: {
                throw new IllegalStateException(this._mode.toString());
            }
        }
    }

    protected void configure(QuickStartGeneratorConfiguration generator, WebAppContext context) throws IOException {
        Object attr = context.getAttribute(GENERATE_ORIGIN);
        if (attr != null) {
            generator.setGenerateOrigin(Boolean.valueOf(attr.toString()));
        }
        if ((attr = context.getAttribute(ORIGIN_ATTRIBUTE)) != null) {
            generator.setOriginAttribute(attr.toString());
        }
        if ((attr = context.getAttribute(QUICKSTART_WEB_XML)) instanceof Resource) {
            generator.setQuickStartWebXml((Resource)attr);
        } else if (attr != null) {
            generator.setQuickStartWebXml(Resource.newResource((String)attr.toString()));
        }
    }

    public void configure(WebAppContext context) throws Exception {
        if (!this._quickStart) {
            super.configure(context);
        } else {
            context.getMetaData().addDescriptorProcessor((DescriptorProcessor)new StandardDescriptorProcessor());
            context.getMetaData().addDescriptorProcessor((DescriptorProcessor)new QuickStartDescriptorProcessor());
            context.getObjectFactory().addDecorator((Decorator)new AnnotationDecorator(context));
            ServletContainerInitializersStarter starter = (ServletContainerInitializersStarter)context.getAttribute("org.eclipse.jetty.containerInitializerStarter");
            if (starter != null) {
                throw new IllegalStateException("ServletContainerInitializersStarter already exists");
            }
            starter = new ServletContainerInitializersStarter(context);
            context.setAttribute("org.eclipse.jetty.containerInitializerStarter", (Object)starter);
            context.addBean((Object)starter, true);
            LOG.debug("configured {}", new Object[]{this});
        }
    }

    protected void quickStart(WebAppContext context, Resource quickStartWebXml) throws Exception {
        this._quickStart = true;
        context.setConfigurations(context.getWebAppConfigurations().stream().filter(c -> !__replacedConfigurations.contains(c.replaces()) && !__replacedConfigurations.contains(c.getClass())).collect(Collectors.toList()).toArray(new Configuration[0]));
        context.getMetaData().setWebXml(quickStartWebXml);
        context.getServletContext().setEffectiveMajorVersion(context.getMetaData().getWebXml().getMajorVersion());
        context.getServletContext().setEffectiveMinorVersion(context.getMetaData().getWebXml().getMinorVersion());
    }

    public Resource getQuickStartWebXml(WebAppContext context) throws Exception {
        Resource webInf = context.getWebInf();
        if (webInf == null || !webInf.exists()) {
            throw new IllegalStateException("No WEB-INF");
        }
        LOG.debug("webinf={}", new Object[]{webInf});
        Resource quickStartWebXml = webInf.addPath("quickstart-web.xml");
        return quickStartWebXml;
    }

    static {
        __replacedConfigurations.add(WebXmlConfiguration.class);
        __replacedConfigurations.add(MetaInfConfiguration.class);
        __replacedConfigurations.add(FragmentConfiguration.class);
        __replacedConfigurations.add(AnnotationConfiguration.class);
    }

    public static enum Mode {
        DISABLED,
        GENERATE,
        AUTO,
        QUICKSTART;

    }
}

