/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.function.BiFunction;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.eclipse.jetty.reactive.client.internal.PublisherContent;
import org.eclipse.jetty.reactive.client.internal.PublisherContentProvider;
import org.eclipse.jetty.reactive.client.internal.RequestEventPublisher;
import org.eclipse.jetty.reactive.client.internal.ResponseEventPublisher;
import org.eclipse.jetty.reactive.client.internal.ResponseListenerProcessor;
import org.eclipse.jetty.reactive.client.internal.StringContent;
import org.reactivestreams.Publisher;

public class ReactiveRequest {
    private final RequestEventPublisher requestEvents = new RequestEventPublisher(this);
    private final ResponseEventPublisher responseEvents = new ResponseEventPublisher(this);
    private final Request request;
    private ReactiveResponse response;

    public static Builder newBuilder(HttpClient httpClient, String uri) {
        return new Builder(httpClient, uri);
    }

    public static Builder newBuilder(Request request) {
        return new Builder(request);
    }

    protected ReactiveRequest(Request request) {
        this.request = request.listener((Request.Listener)this.requestEvents).onResponseBegin(r -> {
            ReactiveRequest reactiveRequest = this;
            synchronized (reactiveRequest) {
                this.response = new ReactiveResponse(this, r);
            }
        }).onResponseBegin((Response.BeginListener)this.responseEvents).onResponseHeaders((Response.HeadersListener)this.responseEvents).onResponseContentDemanded((Response.DemandedContentListener)this.responseEvents).onResponseSuccess((Response.SuccessListener)this.responseEvents).onResponseFailure((Response.FailureListener)this.responseEvents).onComplete((Response.CompleteListener)this.responseEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReactiveResponse getReactiveResponse() {
        ReactiveRequest reactiveRequest = this;
        synchronized (reactiveRequest) {
            return this.response;
        }
    }

    public Request getRequest() {
        return this.request;
    }

    public Publisher<ReactiveResponse> response() {
        return this.response(ReactiveResponse.Content.discard());
    }

    public <T> Publisher<T> response(BiFunction<ReactiveResponse, Publisher<ContentChunk>, Publisher<T>> contentFn) {
        return new ResponseListenerProcessor<T>(this, contentFn);
    }

    public Publisher<Event> requestEvents() {
        return this.requestEvents;
    }

    public Publisher<ReactiveResponse.Event> responseEvents() {
        return this.responseEvents;
    }

    public String toString() {
        return String.format("Reactive[%s]", this.request);
    }

    public static class Builder {
        private final Request request;

        public Builder(HttpClient client, String uri) {
            this(client.newRequest(uri));
        }

        public Builder(Request request) {
            this.request = request;
        }

        public Builder content(Content content) {
            this.request.content((ContentProvider)new PublisherContentProvider(content));
            return this;
        }

        public ReactiveRequest build() {
            return new ReactiveRequest(this.request);
        }
    }

    public static interface Content
    extends Publisher<ContentChunk> {
        public long getLength();

        public String getContentType();

        public static Content fromString(String string, String mediaType, Charset charset) {
            return new StringContent(string, mediaType, charset);
        }

        public static Content fromPublisher(Publisher<ContentChunk> publisher, String contentType) {
            return new PublisherContent(publisher, contentType);
        }

        public static Content fromPublisher(Publisher<ContentChunk> publisher, String mediaType, Charset charset) {
            return Content.fromPublisher(publisher, mediaType + ";charset=" + charset.name());
        }
    }

    public static class Event {
        private final Type type;
        private final ReactiveRequest request;
        private final ByteBuffer content;
        private final Throwable failure;

        public Event(Type type, ReactiveRequest request) {
            this(type, request, null, null);
        }

        public Event(Type type, ReactiveRequest request, ByteBuffer content) {
            this(type, request, content, null);
        }

        public Event(Type type, ReactiveRequest request, Throwable failure) {
            this(type, request, null, failure);
        }

        private Event(Type type, ReactiveRequest request, ByteBuffer content, Throwable failure) {
            this.type = type;
            this.request = request;
            this.content = content;
            this.failure = failure;
        }

        public Type getType() {
            return this.type;
        }

        public ReactiveRequest getRequest() {
            return this.request;
        }

        public ByteBuffer getContent() {
            return this.content;
        }

        public Throwable getFailure() {
            return this.failure;
        }

        public static enum Type {
            QUEUED,
            BEGIN,
            HEADERS,
            COMMIT,
            CONTENT,
            SUCCESS,
            FAILURE;

        }
    }
}

