/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.LongConsumer;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.eclipse.jetty.reactive.client.internal.AbstractSingleProcessor;
import org.eclipse.jetty.reactive.client.internal.QueuedSinglePublisher;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.MathUtils;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseListenerProcessor<T>
extends AbstractSingleProcessor<T, T>
implements Response.Listener {
    private static final Logger logger = LoggerFactory.getLogger(ResponseListenerProcessor.class);
    private final ContentPublisher content = new ContentPublisher();
    private final ReactiveRequest request;
    private final BiFunction<ReactiveResponse, Publisher<ContentChunk>, Publisher<T>> contentFn;
    private boolean requestSent;
    private boolean responseReceived;

    public ResponseListenerProcessor(ReactiveRequest request, BiFunction<ReactiveResponse, Publisher<ContentChunk>, Publisher<T>> contentFn) {
        this.request = request;
        this.contentFn = contentFn;
    }

    public void onBegin(Response response) {
    }

    public boolean onHeader(Response response, HttpField field) {
        return true;
    }

    public void onHeaders(Response response) {
        if (logger.isDebugEnabled()) {
            logger.debug("received response headers {} on {}", (Object)response, (Object)this);
        }
        this.responseReceived = true;
        Publisher<T> publisher = this.contentFn.apply(this.request.getReactiveResponse(), this.content);
        publisher.subscribe((Subscriber)this);
    }

    public void onBeforeContent(Response response, LongConsumer demand) {
        this.content.accept(demand);
    }

    public void onContent(Response response, ByteBuffer content) {
    }

    public void onContent(Response response, ByteBuffer buffer, Callback callback) {
    }

    public void onContent(Response response, LongConsumer demand, ByteBuffer buffer, Callback callback) {
        if (logger.isDebugEnabled()) {
            logger.debug("received response chunk {} {} on {}", new Object[]{response, BufferUtil.toSummaryString((ByteBuffer)buffer), this});
        }
        this.content.offer(demand, new ContentChunk(buffer, callback));
    }

    public void onSuccess(Response response) {
        if (logger.isDebugEnabled()) {
            logger.debug("response complete {} on {}", (Object)response, (Object)this);
        }
    }

    public void onFailure(Response response, Throwable failure) {
        if (logger.isDebugEnabled()) {
            logger.debug("response failure {} on {}", new Object[]{response, this, failure});
        }
    }

    public void onComplete(Result result) {
        if (result.isSucceeded()) {
            this.content.complete();
        } else {
            Throwable failure = result.getFailure();
            if (!this.content.fail(failure) && !this.responseReceived) {
                this.onError(failure);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRequest(Subscriber<? super T> subscriber, long n) {
        boolean send;
        ResponseListenerProcessor responseListenerProcessor = this;
        synchronized (responseListenerProcessor) {
            send = !this.requestSent;
            this.requestSent = true;
        }
        if (send) {
            this.send();
        }
        super.onRequest(subscriber, n);
    }

    public void onNext(T t) {
        this.downStreamOnNext(t);
    }

    private void send() {
        if (logger.isDebugEnabled()) {
            logger.debug("sending request {} from {}", (Object)this.request, (Object)this);
        }
        this.request.getRequest().send((Response.CompleteListener)this);
    }

    @Override
    public String toString() {
        return String.format("%s@%x[%s]", this.getClass().getSimpleName(), this.hashCode(), this.request);
    }

    private static class ContentPublisher
    extends QueuedSinglePublisher<ContentChunk> {
        private final Map<ContentChunk, LongConsumer> chunks = new ConcurrentHashMap<ContentChunk, LongConsumer>();
        private long initialDemand;
        private LongConsumer upstreamDemand;

        private ContentPublisher() {
        }

        public void offer(LongConsumer demand, ContentChunk chunk) {
            this.chunks.put(chunk, demand);
            super.offer(chunk);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void accept(LongConsumer consumer) {
            long demand;
            ContentPublisher contentPublisher = this;
            synchronized (contentPublisher) {
                this.upstreamDemand = consumer;
                demand = this.initialDemand;
                this.initialDemand = 0L;
            }
            consumer.accept(demand);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onRequest(Subscriber<? super ContentChunk> subscriber, long n) {
            LongConsumer demand;
            super.onRequest(subscriber, n);
            ContentPublisher contentPublisher = this;
            synchronized (contentPublisher) {
                demand = this.upstreamDemand;
                if (demand == null) {
                    this.initialDemand = MathUtils.cappedAdd((long)this.initialDemand, (long)n);
                }
            }
            if (demand != null) {
                demand.accept(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onNext(Subscriber<? super ContentChunk> subscriber, ContentChunk item) {
            ContentPublisher contentPublisher = this;
            synchronized (contentPublisher) {
                this.upstreamDemand = this.chunks.remove(item);
            }
            super.onNext(subscriber, item);
        }
    }
}

