/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.eclipse.jetty.reactive.client.internal.AbstractSingleProcessor;

public abstract class AbstractBufferingProcessor<T>
extends AbstractSingleProcessor<Content.Chunk, T> {
    public static final int DEFAULT_MAX_CAPACITY = 0x200000;
    private final List<Content.Chunk> chunks = new ArrayList<Content.Chunk>();
    private final ReactiveResponse response;
    private final int maxCapacity;
    private int capacity;

    public AbstractBufferingProcessor(ReactiveResponse response, int maxCapacity) {
        this.response = response;
        this.maxCapacity = maxCapacity;
    }

    public ReactiveResponse getResponse() {
        return this.response;
    }

    public void onNext(Content.Chunk chunk) {
        this.capacity += chunk.remaining();
        if (this.maxCapacity > 0 && this.capacity > this.maxCapacity || this.capacity < 0) {
            this.upStreamCancel();
            this.onError(new IllegalStateException("buffering capacity %d exceeded".formatted(this.maxCapacity)));
            return;
        }
        this.chunks.add(chunk);
        this.upStreamRequest(1L);
    }

    @Override
    public void onError(Throwable throwable) {
        this.chunks.forEach(Retainable::release);
        super.onError(throwable);
    }

    @Override
    public void onComplete() {
        T result = this.process(this.chunks);
        this.chunks.clear();
        this.downStreamOnNext(result);
        super.onComplete();
    }

    @Override
    public void cancel() {
        this.chunks.forEach(Retainable::release);
        super.cancel();
    }

    protected abstract T process(List<Content.Chunk> var1);
}

