/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.nio.ByteBuffer;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.eclipse.jetty.reactive.client.internal.AbstractEventPublisher;

public class ResponseEventPublisher
extends AbstractEventPublisher<ReactiveResponse.Event>
implements Response.Listener {
    private final ReactiveRequest request;

    public ResponseEventPublisher(ReactiveRequest request) {
        this.request = request;
    }

    public void onBegin(Response response) {
        this.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.BEGIN, this.request.getReactiveResponse()));
    }

    public boolean onHeader(Response response, HttpField field) {
        return true;
    }

    public void onHeaders(Response response) {
        this.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.HEADERS, this.request.getReactiveResponse()));
    }

    public void onContent(Response response, ByteBuffer content) {
    }

    public void onContent(Response response, Content.Chunk chunk, Runnable demander) {
    }

    public void onContentSource(final Response response, final Content.Source source) {
        Runnable reader = new Runnable(){
            final /* synthetic */ ResponseEventPublisher this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Content.Chunk chunk;
                do {
                    if ((chunk = source.read()) == null) {
                        source.demand((Runnable)this);
                        return;
                    }
                    if (Content.Chunk.isFailure((Content.Chunk)chunk)) {
                        this.this$0.onFailure(response, chunk.getFailure());
                        return;
                    }
                    if (chunk.hasRemaining()) {
                        this.this$0.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.CONTENT, this.this$0.request.getReactiveResponse(), chunk.getByteBuffer().asReadOnlyBuffer()));
                    }
                    chunk.release();
                } while (!chunk.isLast());
            }
        };
        reader.run();
    }

    public void onSuccess(Response response) {
        this.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.SUCCESS, this.request.getReactiveResponse()));
    }

    public void onFailure(Response response, Throwable failure) {
        this.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.FAILURE, this.request.getReactiveResponse(), failure));
    }

    public void onComplete(Result result) {
        this.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.COMPLETE, this.request.getReactiveResponse()));
        if (result.isSucceeded()) {
            this.succeed();
        } else {
            this.fail(result.getFailure());
        }
    }
}

