/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterRequestContent
implements Request.Content {
    private static final Logger logger = LoggerFactory.getLogger(AdapterRequestContent.class);
    private final ReactiveRequest.Content reactiveContent;
    private Bridge bridge;

    public AdapterRequestContent(ReactiveRequest.Content content) {
        this.reactiveContent = content;
    }

    public long getLength() {
        return this.reactiveContent.getLength();
    }

    public Content.Chunk read() {
        return this.getOrCreateBridge().read();
    }

    public void demand(Runnable runnable) {
        this.getOrCreateBridge().demand(runnable);
    }

    public void fail(Throwable failure) {
        this.getOrCreateBridge().fail(failure);
    }

    public boolean rewind() {
        boolean rewound = this.reactiveContent.rewind();
        if (logger.isDebugEnabled()) {
            logger.debug("rewinding {} {} on {}", new Object[]{rewound, this.reactiveContent, this.bridge});
        }
        if (rewound) {
            this.bridge = null;
        }
        return rewound;
    }

    private Bridge getOrCreateBridge() {
        if (this.bridge == null) {
            this.bridge = new Bridge();
        }
        return this.bridge;
    }

    public String getContentType() {
        return this.reactiveContent.getContentType();
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }

    private class Bridge
    implements Subscriber<Content.Chunk> {
        private final SerializedInvoker invoker = new SerializedInvoker();
        private final AutoLock lock = new AutoLock();
        private Subscription subscription;
        private Content.Chunk chunk;
        private Throwable failure;
        private boolean complete;
        private Runnable demand;

        private Bridge() {
            AdapterRequestContent.this.reactiveContent.subscribe(this);
        }

        public void onSubscribe(Subscription s) {
            this.subscription = s;
        }

        public void onNext(Content.Chunk c) {
            Runnable onDemand;
            if (logger.isDebugEnabled()) {
                logger.debug("content {} on {}", (Object)c, (Object)this);
            }
            try (AutoLock ignored = this.lock.lock();){
                this.chunk = c;
                onDemand = this.demand;
                this.demand = null;
            }
            this.invoker.run(() -> this.invokeDemand(onDemand));
        }

        public void onError(Throwable error) {
            Runnable onDemand;
            if (logger.isDebugEnabled()) {
                logger.debug("error on {}", (Object)this, (Object)error);
            }
            try (AutoLock ignored = this.lock.lock();){
                this.failure = error;
                onDemand = this.demand;
                this.demand = null;
            }
            this.invoker.run(() -> this.invokeDemand(onDemand));
        }

        public void onComplete() {
            Runnable onDemand;
            if (logger.isDebugEnabled()) {
                logger.debug("complete on {}", (Object)this);
            }
            try (AutoLock ignored = this.lock.lock();){
                this.complete = true;
                onDemand = this.demand;
                this.demand = null;
            }
            this.invoker.run(() -> this.invokeDemand(onDemand));
        }

        private Content.Chunk read() {
            Content.Chunk result;
            try (AutoLock ignored = this.lock.lock();){
                result = this.chunk;
                if (result == null) {
                    if (this.complete) {
                        result = Content.Chunk.EOF;
                    } else if (this.failure != null) {
                        result = Content.Chunk.from((Throwable)this.failure);
                    }
                }
                this.chunk = Content.Chunk.next((Content.Chunk)result);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("read {} on {}", (Object)result, (Object)this);
            }
            return result;
        }

        private void demand(Runnable onDemand) {
            Throwable cause;
            if (logger.isDebugEnabled()) {
                logger.debug("demand {} on {}", (Object)onDemand, (Object)this);
            }
            try (AutoLock ignored = this.lock.lock();){
                if (this.demand != null) {
                    throw new IllegalStateException("demand already exists");
                }
                cause = this.failure;
                if (cause == null) {
                    this.demand = onDemand;
                }
            }
            if (cause == null) {
                this.subscription.request(1L);
            } else {
                this.invoker.run(() -> this.invokeDemand(onDemand));
            }
        }

        private void fail(Throwable cause) {
            Runnable onDemand;
            if (logger.isDebugEnabled()) {
                logger.debug("failure while processing request content on {}", (Object)this, (Object)cause);
            }
            this.subscription.cancel();
            try (AutoLock ignored = this.lock.lock();){
                if (this.failure == null) {
                    this.failure = cause;
                }
                onDemand = this.demand;
                this.demand = null;
            }
            this.invoker.run(() -> this.invokeDemand(onDemand));
        }

        private void invokeDemand(Runnable demand) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("invoking demand callback {} on {}", (Object)demand, (Object)this);
                }
                if (demand != null) {
                    demand.run();
                }
            }
            catch (Throwable x) {
                this.fail(x);
            }
        }

        public String toString() {
            return "%s$%s@%x".formatted(this.getClass().getEnclosingClass().getSimpleName(), this.getClass().getSimpleName(), this.hashCode());
        }
    }
}

