/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import org.eclipse.jetty.rewrite.handler.PatternRule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.Name;

public class HeaderPatternRule
extends PatternRule {
    private String _headerName;
    private String _headerValue;
    private boolean _add;

    public HeaderPatternRule(@Name(value="pattern") String pattern, @Name(value="name") String name, @Name(value="value") String value) {
        super(pattern);
        this._headerName = name;
        this._headerValue = value;
    }

    public String getHeaderName() {
        return this._headerName;
    }

    public void setHeaderName(String name) {
        this._headerName = name;
    }

    public String getHeaderValue() {
        return this._headerValue;
    }

    public void setHeaderValue(String value) {
        this._headerValue = value;
    }

    public boolean isAdd() {
        return this._add;
    }

    public void setAdd(boolean add) {
        this._add = add;
    }

    @Override
    public Request.WrapperProcessor apply(Request.WrapperProcessor input) throws IOException {
        return new Request.WrapperProcessor((Request)input){

            public void process(Request ignored, Response response, Callback callback) throws Exception {
                if (HeaderPatternRule.this.isAdd()) {
                    response.getHeaders().add(HeaderPatternRule.this.getHeaderName(), HeaderPatternRule.this.getHeaderValue());
                } else {
                    response.getHeaders().put(HeaderPatternRule.this.getHeaderName(), HeaderPatternRule.this.getHeaderValue());
                }
                super.process(ignored, response, callback);
            }
        };
    }

    @Override
    public String toString() {
        return "%s[header:%s=%s]".formatted(super.toString(), this.getHeaderName(), this.getHeaderValue());
    }
}

