/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.util.List;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.rewrite.handler.RuleContainer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;

public class RewriteHandler
extends Handler.Wrapper {
    private final RuleContainer _rules;

    public RewriteHandler() {
        this(new RuleContainer());
    }

    public RewriteHandler(RuleContainer rules) {
        this._rules = rules;
        this.addBean(this._rules);
    }

    public RuleContainer getRuleContainer() {
        return this._rules;
    }

    public List<Rule> getRules() {
        return this._rules.getRules();
    }

    public void setRules(List<Rule> rules) {
        this._rules.setRules(rules);
    }

    public void addRule(Rule rule) {
        this._rules.addRule(rule);
    }

    public String getOriginalPathAttribute() {
        return this._rules.getOriginalPathAttribute();
    }

    public void setOriginalPathAttribute(String originalPathAttribute) {
        this._rules.setOriginalPathAttribute(originalPathAttribute);
    }

    public Request.Processor handle(Request request) throws Exception {
        if (!this.isStarted()) {
            return null;
        }
        Request.WrapperProcessor input = new Request.WrapperProcessor(request);
        Request.WrapperProcessor output = this._rules.matchAndApply(input);
        if (output == null) {
            return super.handle(request);
        }
        return output.wrapProcessor(super.handle((Request)output));
    }
}

