/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.regex.Matcher;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.rewrite.handler.RegexRule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.annotation.Name;

public class RewriteRegexRule
extends RegexRule {
    private String replacement;

    public RewriteRegexRule(@Name(value="regex") String regex, @Name(value="replacement") String replacement) {
        super(regex);
        this.setReplacement(replacement);
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    @Override
    public Request.WrapperProcessor apply(Request.WrapperProcessor input, Matcher matcher) throws IOException {
        HttpURI httpURI = input.getHttpURI();
        String replacedPath = matcher.replaceAll(this.replacement);
        HttpURI.Mutable newURI = HttpURI.build((HttpURI)httpURI, (String)replacedPath);
        return new Request.WrapperProcessor((Request)input, (HttpURI)newURI){
            final /* synthetic */ HttpURI val$newURI;
            {
                this.val$newURI = httpURI;
                super(arg0);
            }

            public HttpURI getHttpURI() {
                return this.val$newURI;
            }
        };
    }

    @Override
    public String toString() {
        return "%s[rewrite:%s]".formatted(super.toString(), this.replacement);
    }
}

