/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.rewrite.handler.PatternRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.Name;

public class RedirectPatternRule
extends PatternRule {
    private String _location;
    private int _statusCode = 302;

    public RedirectPatternRule() {
    }

    public RedirectPatternRule(@Name(value="pattern") String pattern, @Name(value="location") String location) {
        super(pattern);
        this._location = location;
    }

    @Override
    public boolean isTerminating() {
        return true;
    }

    public String getLocation() {
        return this._location;
    }

    public void setLocation(String value) {
        this._location = value;
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    public void setStatusCode(int statusCode) {
        if (!HttpStatus.isRedirection((int)statusCode)) {
            throw new IllegalArgumentException("Invalid redirect status code " + statusCode + " (must be a value between 300 and 399)");
        }
        this._statusCode = statusCode;
    }

    @Override
    public Rule.Handler apply(Rule.Handler input) throws IOException {
        return new Rule.Handler((Request)input){

            @Override
            public boolean handle(Response response, Callback callback) {
                String location = RedirectPatternRule.this.getLocation();
                response.setStatus(RedirectPatternRule.this.getStatusCode());
                response.getHeaders().put(HttpHeader.LOCATION, Request.toRedirectURI((Request)this, (String)location));
                callback.succeeded();
                return true;
            }
        };
    }

    @Override
    public String toString() {
        return "%s[redirect:%d>%s]".formatted(super.toString(), this.getStatusCode(), this.getLocation());
    }
}

