/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.util.List;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.rewrite.handler.RuleContainer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class RewriteHandler
extends Handler.Wrapper {
    private final RuleContainer _rules;

    public RewriteHandler() {
        this(new RuleContainer());
    }

    public RewriteHandler(RuleContainer rules) {
        this._rules = rules;
        this.addBean(this._rules);
    }

    public RuleContainer getRuleContainer() {
        return this._rules;
    }

    public List<Rule> getRules() {
        return this._rules.getRules();
    }

    public void setRules(List<Rule> rules) {
        this._rules.setRules(rules);
    }

    public void addRule(Rule rule) {
        this._rules.addRule(rule);
    }

    public String getOriginalPathAttribute() {
        return this._rules.getOriginalPathAttribute();
    }

    public void setOriginalPathAttribute(String originalPathAttribute) {
        this._rules.setOriginalPathAttribute(originalPathAttribute);
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        if (!this.isStarted()) {
            return false;
        }
        Rule.Handler input = new Rule.Handler(request);
        Rule.Handler output = this._rules.matchAndApply(input);
        if (output == null) {
            return super.handle(request, response, callback);
        }
        output.setHandler((Request.Handler)this.getHandler());
        return output.handle((Request)output, response, callback);
    }
}

