/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.List;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.rewrite.handler.PatternRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.Name;

public class CookiePatternRule
extends PatternRule {
    private String _name;
    private String _value;

    public CookiePatternRule() {
    }

    public CookiePatternRule(@Name(value="pattern") String pattern, @Name(value="name") String name, @Name(value="value") String value) {
        super(pattern);
        this.setName(name);
        this.setValue(value);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    @Override
    public Rule.Handler apply(Rule.Handler input) throws IOException {
        List cookies = Request.getCookies((Request)input);
        for (HttpCookie cookie : cookies) {
            if (!this._name.equals(cookie.getName()) || !this._value.equals(cookie.getValue())) continue;
            return null;
        }
        return new Rule.Handler(input){

            @Override
            protected boolean handle(Response response, Callback callback) throws Exception {
                Response.addCookie((Response)response, (HttpCookie)HttpCookie.from((String)CookiePatternRule.this._name, (String)CookiePatternRule.this._value));
                return super.handle(response, callback);
            }
        };
    }

    @Override
    public String toString() {
        return "%s@%x[set-cookie:%s=%s]".formatted(super.toString(), this.hashCode(), this.getName(), this.getValue());
    }
}

