/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ScopedHandler;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class RegexTargetHandler
extends ScopedHandler {
    private static final Logger LOG = Log.getLogger(RegexTargetHandler.class);
    public static final String REGEX_MAPPINGS = "org.eclipse.jetty.rewrite.handler.REGEX_MAPPINGS";
    private final List<RegexMapping> _patterns = new CopyOnWriteArrayList<RegexMapping>();

    public void addPatternTarget(String pattern, String target) {
        this._patterns.add(new RegexMapping(pattern, target));
    }

    protected void doStart() throws Exception {
        super.doStart();
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        if (context != null) {
            String[] mappings;
            String config = context.getInitParameter(REGEX_MAPPINGS);
            LOG.debug("{}={}", new Object[]{REGEX_MAPPINGS, config});
            for (String mapping : mappings = config.split("\\s*,\\s*")) {
                String[] parts = (mapping = mapping.trim()).split("\\s*==\\s*");
                if (parts.length == 2) {
                    String pattern = parts[0];
                    String target = parts[1];
                    this.addPatternTarget(pattern, target);
                    continue;
                }
                LOG.warn("Bad regex mapping: " + mapping, new Object[0]);
            }
        }
    }

    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        for (RegexMapping rm : this._patterns) {
            String sp;
            String pi;
            Matcher m = rm._pattern.matcher(target);
            if (!m.matches()) continue;
            String new_target = rm._target;
            if (m.groupCount() == 1 && target.endsWith(m.group(1))) {
                pi = m.group(1);
                sp = target.substring(0, target.length() - pi.length());
            } else {
                sp = target;
                pi = null;
            }
            baseRequest.setServletPath(sp);
            baseRequest.setPathInfo(pi);
            baseRequest.setAttribute("org.eclipse.jetty.servlet.REGEX_PATH", (Object)target);
            super.nextScope(new_target, baseRequest, request, response);
            return;
        }
        super.nextScope(target, baseRequest, request, response);
    }

    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String path = (String)baseRequest.getAttribute("org.eclipse.jetty.servlet.REGEX_PATH");
        if (path == null) {
            path = target;
        } else {
            baseRequest.setAttribute("org.eclipse.jetty.servlet.REGEX_PATH", null);
        }
        super.nextHandle(path, baseRequest, request, response);
    }

    public void dump(Appendable out, String indent) throws IOException {
        AggregateLifeCycle.dumpObject((Appendable)out, (Object)((Object)this));
        AggregateLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{this._patterns, Collections.singletonList(this.getHandler())});
    }

    static class RegexMapping {
        final Pattern _pattern;
        final String _target;

        RegexMapping(String regex, String target) {
            this._pattern = Pattern.compile(regex);
            this._target = target;
        }

        public String toString() {
            return this._pattern + "==" + this._target;
        }
    }
}

