/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.script;

import java.lang.annotation.Annotation;
import java.util.Objects;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="5.1")
@Deprecated
public final class Script {
    public static final String DEFAULT_SCRIPT_ENGINE_NAME = "Nashorn";
    public static final String BIND_JUNIT_TAGS = "junitTags";
    public static final String BIND_JUNIT_UNIQUE_ID = "junitUniqueId";
    public static final String BIND_JUNIT_DISPLAY_NAME = "junitDisplayName";
    public static final String BIND_JUNIT_CONFIGURATION_PARAMETER = "junitConfigurationParameter";
    static final String BIND_SYSTEM_PROPERTY = "systemProperty";
    static final String BIND_SYSTEM_ENVIRONMENT = "systemEnvironment";
    public static final String DEFAULT_SCRIPT_REASON_PATTERN = "Script `{source}` evaluated to: {result}";
    private static final String REASON_ANNOTATION_PLACEHOLDER = "{annotation}";
    private static final String REASON_RESULT_PLACEHOLDER = "{result}";
    private static final String REASON_SOURCE_PLACEHOLDER = "{source}";
    private final Class<? extends Annotation> annotationType;
    private final String annotationAsString;
    private final String engine;
    private final String source;
    private final String reason;
    private final int hashCode;

    public Script(Annotation annotation, String engine, String source, String reason) {
        this(Preconditions.notNull(annotation, "annotation must not be null").annotationType(), annotation.toString(), engine, source, reason);
    }

    public Script(Class<? extends Annotation> annotationType, String annotationAsString, String engine, String source, String reason) {
        Preconditions.notNull(annotationType, "annotationType must not be null");
        Preconditions.notNull(annotationAsString, "annotationAsString must not be null");
        Preconditions.notBlank(engine, "engine must not be blank");
        Preconditions.notBlank(source, "source must not be blank");
        Preconditions.notNull(reason, "reason must not be null");
        this.annotationType = annotationType;
        this.annotationAsString = annotationAsString;
        this.engine = engine;
        this.source = source;
        this.reason = reason;
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        return Objects.hash(this.annotationType.getTypeName(), this.engine, this.source);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Script otherScript = (Script)other;
        return this.hashCode == otherScript.hashCode;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getAnnotationAsString() {
        return this.annotationAsString;
    }

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    public String getEngine() {
        return this.engine;
    }

    public String getReason() {
        return this.reason;
    }

    public String getSource() {
        return this.source;
    }

    public String toReasonString(String resultAsString) {
        return this.reason.replace(REASON_ANNOTATION_PLACEHOLDER, this.getAnnotationAsString()).replace(REASON_SOURCE_PLACEHOLDER, this.getSource()).replace(REASON_RESULT_PLACEHOLDER, resultAsString);
    }
}

