/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.PathSpecGroup;
import org.eclipse.jetty.security.AuthenticationState;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.security.DefaultAuthenticatorFactory;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecurityHandler
extends Handler.Wrapper
implements Authenticator.Configuration {
    public static String SESSION_AUTHENTICATED_ATTRIBUTE = "org.eclipse.jetty.security.sessionAuthenticated";
    private static final Logger LOG = LoggerFactory.getLogger(SecurityHandler.class);
    private static final List<Authenticator.Factory> __knownAuthenticatorFactories = new ArrayList<Authenticator.Factory>();
    private Authenticator _authenticator;
    private Authenticator.Factory _authenticatorFactory;
    private String _realmName;
    private String _authenticationType;
    private final Map<String, String> _parameters = new HashMap<String, String>();
    private LoginService _loginService;
    private IdentityService _identityService;
    private boolean _renewSession = true;
    private AuthenticationState.Deferred _deferred;

    protected SecurityHandler() {
        this.addBean(new DumpableCollection("knownAuthenticatorFactories", __knownAuthenticatorFactories));
    }

    @Override
    public IdentityService getIdentityService() {
        return this._identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this.updateBean(this._identityService, identityService);
        this._identityService = identityService;
    }

    @Override
    public LoginService getLoginService() {
        return this._loginService;
    }

    public void setLoginService(LoginService loginService) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this.updateBean(this._loginService, loginService);
        this._loginService = loginService;
    }

    public Authenticator getAuthenticator() {
        return this._authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this.updateBean(this._authenticator, authenticator);
        this._authenticator = authenticator;
        if (this._authenticator != null) {
            this._authenticationType = this._authenticator.getAuthenticationType();
        }
    }

    public Authenticator.Factory getAuthenticatorFactory() {
        return this._authenticatorFactory;
    }

    public void setAuthenticatorFactory(Authenticator.Factory authenticatorFactory) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this.updateBean(this._authenticatorFactory, authenticatorFactory);
        this._authenticatorFactory = authenticatorFactory;
    }

    public List<Authenticator.Factory> getKnownAuthenticatorFactories() {
        return __knownAuthenticatorFactories;
    }

    @Override
    public String getRealmName() {
        return this._realmName;
    }

    public void setRealmName(String realmName) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._realmName = realmName;
    }

    @Override
    public String getAuthenticationType() {
        return this._authenticationType;
    }

    public void setAuthenticationType(String authenticationType) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._authenticationType = authenticationType;
        if (this._authenticator != null && !this._authenticator.getAuthenticationType().equals(this._authenticationType)) {
            this._authenticator = null;
        }
    }

    @Override
    public String getParameter(String key) {
        return this._parameters.get(key);
    }

    @Override
    public Set<String> getParameterNames() {
        return this._parameters.keySet();
    }

    public String setParameter(String key, String value) {
        if (this.isStarted()) {
            throw new IllegalStateException("started");
        }
        return this._parameters.put(key, value);
    }

    protected LoginService findLoginService() {
        Collection list = this.getServer().getBeans(LoginService.class);
        LoginService service = null;
        String realm = this.getRealmName();
        if (realm != null) {
            for (LoginService s : list) {
                if (s.getName() == null || !s.getName().equals(realm)) continue;
                service = s;
                break;
            }
        } else if (list.size() == 1) {
            service = (LoginService)list.iterator().next();
        }
        return service;
    }

    protected IdentityService findIdentityService() {
        return (IdentityService)this.getServer().getBean(IdentityService.class);
    }

    protected void doStart() throws Exception {
        block19: {
            Context context;
            block20: {
                if (this._loginService == null) {
                    this.setLoginService(this.findLoginService());
                    if (this._loginService != null) {
                        this.unmanage(this._loginService);
                    }
                }
                if (this._identityService == null) {
                    if (this._loginService != null) {
                        this.setIdentityService(this._loginService.getIdentityService());
                    }
                    if (this._identityService == null) {
                        this.setIdentityService(this.findIdentityService());
                    }
                    if (this._identityService == null) {
                        this.setIdentityService(new DefaultIdentityService());
                        this.manage(this._identityService);
                    } else {
                        this.unmanage(this._identityService);
                    }
                }
                if (this._loginService != null) {
                    if (this._loginService.getIdentityService() == null) {
                        this._loginService.setIdentityService(this._identityService);
                    } else if (this._loginService.getIdentityService() != this._identityService) {
                        throw new IllegalStateException("LoginService has different IdentityService to " + String.valueOf(this));
                    }
                }
                context = ContextHandler.getCurrentContext();
                if (this._authenticator != null) break block19;
                if (this._authenticatorFactory == null) break block20;
                Authenticator authenticator = this._authenticatorFactory.getAuthenticator(this.getServer(), context, this);
                if (authenticator == null) break block19;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Created authenticator {} with {}", (Object)authenticator, (Object)this._authenticatorFactory);
                }
                this.setAuthenticator(authenticator);
                break block19;
            }
            for (Authenticator.Factory factory : this.getKnownAuthenticatorFactories()) {
                Authenticator authenticator = factory.getAuthenticator(this.getServer(), context, this);
                if (authenticator == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Created authenticator {} with {}", (Object)authenticator, (Object)factory);
                }
                this.setAuthenticator(authenticator);
                break;
            }
        }
        if (this._authenticator == null) {
            this.setAuthenticator(new Authenticator.NoOp());
        }
        if (this._authenticator != null) {
            this._authenticator.setConfiguration(this);
        } else if (this._realmName != null) {
            LOG.warn("No Authenticator for {}", (Object)this);
            throw new IllegalStateException("No Authenticator");
        }
        Authenticator authenticator = this._authenticator;
        if (authenticator instanceof LoginAuthenticator) {
            LoginAuthenticator loginAuthenticator = (LoginAuthenticator)authenticator;
            this._deferred = AuthenticationState.defer(loginAuthenticator);
            this.addBean(this._deferred);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (!this.isManaged(this._identityService)) {
            this.removeBean(this._identityService);
            this._identityService = null;
        }
        if (!this.isManaged(this._loginService)) {
            this.removeBean(this._loginService);
            this._loginService = null;
        }
        if (this._deferred != null) {
            this.removeBean(this._deferred);
            this._deferred = null;
        }
        super.doStop();
    }

    @Override
    public boolean isSessionRenewedOnAuthentication() {
        return this._renewSession;
    }

    public void setSessionRenewedOnAuthentication(boolean renew) {
        this._renewSession = renew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        boolean bl;
        IdentityService.Association association;
        AuthenticationState authenticationState;
        Handler next = this.getHandler();
        if (next == null) {
            return false;
        }
        String pathInContext = Request.getPathInContext((Request)request);
        Constraint constraint = this.getConstraint(pathInContext, request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getConstraint({}) -> {}", (Object)pathInContext, (Object)constraint);
        }
        if (constraint == null) {
            constraint = Constraint.ALLOWED;
        }
        if (constraint.getAuthorization() == Constraint.Authorization.FORBIDDEN) {
            Response.writeError((Request)request, (Response)response, (Callback)callback, (int)403);
            return true;
        }
        if (Constraint.Transport.SECURE.equals((Object)constraint.getTransport()) && !request.isSecure()) {
            this.redirectToSecure(request, response, callback);
            return true;
        }
        Constraint.Authorization constraintAuthorization = constraint.getAuthorization();
        if ((constraintAuthorization = this._authenticator.getConstraintAuthentication(pathInContext, constraintAuthorization, arg_0 -> ((Request)request).getSession(arg_0))) == Constraint.Authorization.INHERIT) {
            constraintAuthorization = Constraint.Authorization.ALLOWED;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("constraintAuthorization {}", (Object)constraintAuthorization);
        }
        boolean mustValidate = constraintAuthorization != Constraint.Authorization.ALLOWED;
        AuthenticationState authenticationState2 = authenticationState = mustValidate ? this._authenticator.validateRequest(request, response, callback) : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("AuthenticationState {}", (Object)authenticationState);
        }
        if (authenticationState instanceof AuthenticationState.ResponseSent) {
            return true;
        }
        if (mustValidate && this.isNotAuthorized(constraint, authenticationState)) {
            Response.writeError((Request)request, (Response)response, (Callback)callback, (int)403, (String)"!authorized");
            return true;
        }
        if (authenticationState == null) {
            authenticationState = this._deferred;
        }
        AuthenticationState.setAuthenticationState(request, authenticationState);
        if (authenticationState instanceof AuthenticationState.Succeeded) {
            AuthenticationState.Succeeded user = (AuthenticationState.Succeeded)authenticationState;
            association = this._identityService.associate(user.getUserIdentity(), null);
        } else {
            association = null;
        }
        IdentityService.Association association2 = association;
        try {
            bl = next.handle(this._authenticator.prepareRequest(request, authenticationState), response, callback);
        }
        catch (Throwable throwable) {
            try {
                if (association2 == null && authenticationState instanceof AuthenticationState.Deferred) {
                    AuthenticationState.Deferred deferred = (AuthenticationState.Deferred)authenticationState;
                    association2 = deferred.getAssociation();
                }
                if (association2 != null) {
                    association2.close();
                }
                throw throwable;
            }
            catch (ServerAuthException e) {
                Response.writeError((Request)request, (Response)response, (Callback)callback, (int)500, (String)e.getMessage());
                return true;
            }
        }
        if (association2 == null && authenticationState instanceof AuthenticationState.Deferred) {
            AuthenticationState.Deferred deferred = (AuthenticationState.Deferred)authenticationState;
            association2 = deferred.getAssociation();
        }
        if (association2 != null) {
            association2.close();
        }
        return bl;
    }

    public static SecurityHandler getCurrentSecurityHandler() {
        ContextHandler contextHandler = ContextHandler.getCurrentContextHandler();
        if (contextHandler != null) {
            return (SecurityHandler)contextHandler.getDescendant(SecurityHandler.class);
        }
        return null;
    }

    protected abstract Constraint getConstraint(String var1, Request var2);

    protected void redirectToSecure(Request request, Response response, Callback callback) {
        HttpConfiguration httpConfig = request.getConnectionMetaData().getHttpConfiguration();
        if (httpConfig.getSecurePort() > 0) {
            String scheme = httpConfig.getSecureScheme();
            int port = httpConfig.getSecurePort();
            String url = URIUtil.newURI((String)scheme, (String)Request.getServerName((Request)request), (int)port, (String)request.getHttpURI().getPath(), (String)request.getHttpURI().getQuery());
            response.getHeaders().putLongField(HttpHeader.CONTENT_LENGTH, 0L);
            Response.sendRedirect((Request)request, (Response)response, (Callback)callback, (int)302, (String)url, (boolean)true);
        } else {
            Response.writeError((Request)request, (Response)response, (Callback)callback, (int)403, (String)"!Secure");
        }
    }

    protected boolean isNotAuthorized(Constraint constraint, AuthenticationState authenticationState) {
        UserIdentity userIdentity;
        if (authenticationState instanceof AuthenticationState.Succeeded) {
            AuthenticationState.Succeeded user = (AuthenticationState.Succeeded)authenticationState;
            userIdentity = user.getUserIdentity();
        } else {
            userIdentity = null;
        }
        UserIdentity userIdentity2 = userIdentity;
        return switch (constraint.getAuthorization()) {
            default -> throw new IncompatibleClassChangeError();
            case Constraint.Authorization.FORBIDDEN, Constraint.Authorization.ALLOWED, Constraint.Authorization.INHERIT -> false;
            case Constraint.Authorization.ANY_USER -> {
                if (userIdentity2 == null || userIdentity2.getUserPrincipal() == null) {
                    yield true;
                }
                yield false;
            }
            case Constraint.Authorization.KNOWN_ROLE -> {
                if (userIdentity2 != null && userIdentity2.getUserPrincipal() != null) {
                    for (String role : this.getKnownRoles()) {
                        if (!userIdentity2.isUserInRole(role)) continue;
                        yield false;
                    }
                }
                yield true;
            }
            case Constraint.Authorization.SPECIFIC_ROLE -> {
                if (userIdentity2 != null && userIdentity2.getUserPrincipal() != null) {
                    for (String role : constraint.getRoles()) {
                        if (!userIdentity2.isUserInRole(role)) continue;
                        yield false;
                    }
                }
                yield true;
            }
        };
    }

    protected Set<String> getKnownRoles() {
        return Collections.emptySet();
    }

    static {
        TypeUtil.serviceStream(ServiceLoader.load(Authenticator.Factory.class)).forEach(__knownAuthenticatorFactories::add);
        __knownAuthenticatorFactories.add(new DefaultAuthenticatorFactory());
    }

    public static class PathMapped
    extends SecurityHandler
    implements Comparator<PathSpec> {
        private final PathMappings<Constraint> _mappings = new PathMappings();
        private final Set<String> _knownRoles = new HashSet<String>();

        public Constraint put(String pathSpec, Constraint constraint) {
            return this.put(PathSpec.from((String)pathSpec), constraint);
        }

        public Constraint put(PathSpec pathSpec, Constraint constraint) {
            Set<String> roles = constraint.getRoles();
            if (roles != null) {
                this._knownRoles.addAll(roles);
            }
            return (Constraint)this._mappings.put(pathSpec, (Object)constraint);
        }

        public Constraint get(PathSpec pathSpec) {
            return (Constraint)this._mappings.get(pathSpec);
        }

        public Constraint remove(PathSpec pathSpec) {
            Constraint removed = (Constraint)this._mappings.remove(pathSpec);
            this._knownRoles.clear();
            this._mappings.values().forEach(c -> {
                Set<String> roles = c.getRoles();
                if (roles != null) {
                    this._knownRoles.addAll(roles);
                }
            });
            return removed;
        }

        @Override
        protected Constraint getConstraint(String pathInContext, Request request) {
            List matches = this._mappings.getMatches(pathInContext);
            if (matches == null || matches.isEmpty()) {
                return null;
            }
            if (matches.size() == 1) {
                return (Constraint)((MappedResource)matches.get(0)).getResource();
            }
            matches.sort(this::compare);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getConstraint {} -> {}", (Object)pathInContext, (Object)matches);
            }
            Constraint constraint = null;
            for (MappedResource c : matches) {
                constraint = Constraint.combine(constraint, (Constraint)c.getResource());
            }
            return constraint;
        }

        @Override
        public int compare(PathSpec ps1, PathSpec ps2) {
            PathSpecGroup g2;
            PathSpecGroup g1 = ps1.getGroup();
            if (g1.equals((Object)(g2 = ps2.getGroup()))) {
                return Integer.compare(ps1.getSpecLength(), ps2.getSpecLength());
            }
            return Integer.compare(this.pathSpecGroupPrecedence(g1), this.pathSpecGroupPrecedence(g2));
        }

        @Override
        int compare(MappedResource<Constraint> c1, MappedResource<Constraint> c2) {
            PathSpecGroup g1 = c1.getPathSpec().getGroup();
            PathSpecGroup g2 = c2.getPathSpec().getGroup();
            int l1 = c1.getPathSpec().getSpecLength();
            int l2 = c2.getPathSpec().getSpecLength();
            if (g1.equals((Object)g2)) {
                return Integer.compare(l1, l2);
            }
            return Integer.compare(this.pathSpecGroupPrecedence(g1), this.pathSpecGroupPrecedence(g2));
        }

        protected int pathSpecGroupPrecedence(PathSpecGroup group) {
            return switch (group) {
                default -> throw new IncompatibleClassChangeError();
                case PathSpecGroup.EXACT -> 5;
                case PathSpecGroup.ROOT -> 4;
                case PathSpecGroup.SUFFIX_GLOB -> 3;
                case PathSpecGroup.MIDDLE_GLOB -> 2;
                case PathSpecGroup.PREFIX_GLOB -> 1;
                case PathSpecGroup.DEFAULT -> 0;
            };
        }

        @Override
        protected Set<String> getKnownRoles() {
            return this._knownRoles;
        }
    }

    public class NotChecked
    implements Principal {
        @Override
        public String getName() {
            return null;
        }

        @Override
        public String toString() {
            return "NOT CHECKED";
        }

        public SecurityHandler getSecurityHandler() {
            return SecurityHandler.this;
        }
    }
}

