/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import org.eclipse.jetty.security.DefaultUserIdentity;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.RoleRunAsToken;
import org.eclipse.jetty.security.RunAsToken;
import org.eclipse.jetty.server.UserIdentity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIdentityService
implements IdentityService<UserIdentity, RoleRunAsToken> {
    @Override
    public UserIdentity associate(UserIdentity user, UserIdentity.Scope scope) {
        Map roleRefMap = scope.getRoleRefMap();
        if (roleRefMap != null && roleRefMap.size() > 0) {
            return new RoleRefUserIdentity(user, roleRefMap);
        }
        return user;
    }

    @Override
    public void disassociate(UserIdentity scoped) {
    }

    @Override
    public RoleRunAsToken associateRunAs(RunAsToken token) {
        return null;
    }

    @Override
    public void disassociateRunAs(RoleRunAsToken lastToken) {
    }

    @Override
    public RunAsToken newRunAsToken(String runAsName) {
        return new RoleRunAsToken(runAsName);
    }

    @Override
    public UserIdentity newSystemUserIdentity() {
        return null;
    }

    @Override
    public UserIdentity newUserIdentity(Subject subject, Principal userPrincipal, String[] roles) {
        return new DefaultUserIdentity(subject, userPrincipal, roles);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RoleRefUserIdentity
    implements UserIdentity {
        private final UserIdentity _delegate;
        private final Map<String, String> _roleRefMap;

        public RoleRefUserIdentity(UserIdentity user, Map<String, String> roleRefMap) {
            this._delegate = user;
            this._roleRefMap = roleRefMap;
        }

        public String[] getRoles() {
            return this._delegate.getRoles();
        }

        public Subject getSubject() {
            return this._delegate.getSubject();
        }

        public Principal getUserPrincipal() {
            return this._delegate.getUserPrincipal();
        }

        public boolean isUserInRole(String role) {
            String link = this._roleRefMap.get(role);
            return this._delegate.isUserInRole(link == null ? role : link);
        }
    }
}

