/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.security.Authentication;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultAuthentication;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.server.UserIdentity;

public class LazyAuthentication
implements Authentication {
    private static final Subject unauthenticatedSubject = new Subject();
    private final Authenticator _serverAuthentication;
    private final ServletRequest _request;
    private final ServletResponse _response;
    private Authentication _delegate;

    public LazyAuthentication(Authenticator serverAuthentication, ServletRequest request, ServletResponse response) {
        if (serverAuthentication == null) {
            throw new NullPointerException("No ServerAuthentication");
        }
        this._serverAuthentication = serverAuthentication;
        this._request = request;
        this._response = response;
    }

    private Authentication getDelegate() {
        if (this._delegate == null) {
            try {
                this._delegate = this._serverAuthentication.validateRequest(this._request, this._response, false);
            }
            catch (ServerAuthException e) {
                this._delegate = DefaultAuthentication.SEND_FAILURE_RESULTS;
            }
        }
        return this._delegate;
    }

    public Authentication.Status getAuthStatus() {
        return this.getDelegate().getAuthStatus();
    }

    public boolean isSuccess() {
        return this.getDelegate().isSuccess();
    }

    public UserIdentity getUserIdentity() {
        return this._delegate == null ? UserIdentity.UNAUTHENTICATED_IDENTITY : this._delegate.getUserIdentity();
    }

    public String getAuthMethod() {
        return this.getDelegate().getAuthMethod();
    }

    public String toString() {
        return "{Lazy," + this._delegate + "}";
    }
}

