/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.security.B64Code;
import org.eclipse.jetty.security.Authentication;
import org.eclipse.jetty.security.DefaultAuthentication;
import org.eclipse.jetty.security.DefaultUserIdentity;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.StringUtil;

public class BasicAuthenticator
extends LoginAuthenticator {
    public String getAuthMethod() {
        return "BASIC";
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String credentials = request.getHeader("Authorization");
        try {
            if (credentials != null) {
                String password;
                int i;
                credentials = credentials.substring(credentials.indexOf(32) + 1);
                String username = (credentials = B64Code.decode((String)credentials, (String)StringUtil.__ISO_8859_1)).substring(0, i = credentials.indexOf(58));
                UserIdentity user = this._loginService.login(username, password = credentials.substring(i + 1));
                if (user != null) {
                    if (user instanceof DefaultUserIdentity) {
                        return ((DefaultUserIdentity)user).SUCCESSFUL_BASIC;
                    }
                    return new DefaultAuthentication(Authentication.Status.SUCCESS, "BASIC", user);
                }
            }
            if (!mandatory) {
                return DefaultAuthentication.SUCCESS_UNAUTH_RESULTS;
            }
            response.setHeader("WWW-Authenticate", "basic realm=\"" + this._loginService.getName() + '\"');
            response.sendError(401);
            return DefaultAuthentication.SEND_CONTINUE_RESULTS;
        }
        catch (IOException e) {
            throw new ServerAuthException(e);
        }
    }

    public Authentication.Status secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication validatedUser) throws ServerAuthException {
        return Authentication.Status.SUCCESS;
    }
}

