/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.authentication.DelegateAuthenticator;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;

public class UserAuthentication
implements Authentication.User {
    private final Authenticator _authenticator;
    private final UserIdentity _userIdentity;

    public UserAuthentication(Authenticator authenticator, UserIdentity userIdentity) {
        this._authenticator = authenticator;
        this._userIdentity = userIdentity;
    }

    public String getAuthMethod() {
        return this._authenticator.getAuthMethod();
    }

    public UserIdentity getUserIdentity() {
        return this._userIdentity;
    }

    public boolean isUserInRole(UserIdentity.Scope scope, String role) {
        if (scope != null && scope.getRoleRefMap() != null) {
            role = (String)scope.getRoleRefMap().get(role);
        }
        return this._userIdentity.isUserInRole(role);
    }

    public void logout() {
        Authenticator authenticator = this._authenticator;
        while (true) {
            if (authenticator instanceof LoginAuthenticator) {
                ((LoginAuthenticator)authenticator).getLoginService().logout(this.getUserIdentity());
                break;
            }
            if (!(authenticator instanceof DelegateAuthenticator)) break;
            authenticator = ((DelegateAuthenticator)authenticator).getDelegate();
        }
    }

    public String toString() {
        return "{Auth," + this.getAuthMethod() + "," + this._userIdentity + "}";
    }
}

