/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import java.security.MessageDigest;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.security.Credential;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class DigestAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = Log.getLogger(DigestAuthenticator.class);
    protected long _maxNonceAge = 0L;
    protected long _nonceSecret = (long)this.hashCode() ^ System.currentTimeMillis();
    protected boolean _useStale = false;

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        super.setConfiguration(configuration);
        String mna = configuration.getInitParameter("maxNonceAge");
        if (mna != null) {
            this._maxNonceAge = Long.valueOf(mna);
        }
    }

    public String getAuthMethod() {
        return "DIGEST";
    }

    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        if (!mandatory) {
            return this._deferred;
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String credentials = request.getHeader("Authorization");
        try {
            boolean stale = false;
            if (credentials != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Credentials: " + credentials, new Object[0]);
                }
                QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(credentials, "=, ", true, false);
                Digest digest = new Digest(request.getMethod());
                String last = null;
                String name = null;
                block7: while (tokenizer.hasMoreTokens()) {
                    String tok = tokenizer.nextToken();
                    char c = tok.length() == 1 ? tok.charAt(0) : (char)'\u0000';
                    switch (c) {
                        case '=': {
                            name = last;
                            last = tok;
                            continue block7;
                        }
                        case ',': {
                            name = null;
                        }
                        case ' ': {
                            continue block7;
                        }
                    }
                    last = tok;
                    if (name == null) continue;
                    if ("username".equalsIgnoreCase(name)) {
                        digest.username = tok;
                    } else if ("realm".equalsIgnoreCase(name)) {
                        digest.realm = tok;
                    } else if ("nonce".equalsIgnoreCase(name)) {
                        digest.nonce = tok;
                    } else if ("nc".equalsIgnoreCase(name)) {
                        digest.nc = tok;
                    } else if ("cnonce".equalsIgnoreCase(name)) {
                        digest.cnonce = tok;
                    } else if ("qop".equalsIgnoreCase(name)) {
                        digest.qop = tok;
                    } else if ("uri".equalsIgnoreCase(name)) {
                        digest.uri = tok;
                    } else if ("response".equalsIgnoreCase(name)) {
                        digest.response = tok;
                    }
                    name = null;
                }
                int n = this.checkNonce(digest.nonce, (Request)request);
                if (n > 0) {
                    UserIdentity user = this._loginService.login(digest.username, (Object)digest);
                    if (user != null) {
                        this.renewSessionOnAuthentication(request, response);
                        return new UserAuthentication(this.getAuthMethod(), user);
                    }
                } else if (n == 0) {
                    stale = true;
                }
            }
            if (!this._deferred.isDeferred(response)) {
                String domain = request.getContextPath();
                if (domain == null) {
                    domain = "/";
                }
                response.setHeader("WWW-Authenticate", "Digest realm=\"" + this._loginService.getName() + "\", domain=\"" + domain + "\", nonce=\"" + this.newNonce((Request)request) + "\", algorithm=MD5, qop=\"auth\"" + (this._useStale ? " stale=" + stale : ""));
                response.sendError(401);
                return Authentication.SEND_CONTINUE;
            }
            return Authentication.UNAUTHENTICATED;
        }
        catch (IOException e) {
            throw new ServerAuthException(e);
        }
    }

    public String newNonce(Request request) {
        long ts = request.getTimeStamp();
        long sk = this._nonceSecret;
        byte[] nounce = new byte[24];
        for (int i = 0; i < 8; ++i) {
            nounce[i] = (byte)(ts & 0xFFL);
            ts >>= 8;
            nounce[8 + i] = (byte)(sk & 0xFFL);
            sk >>= 8;
        }
        byte[] hash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(nounce, 0, 16);
            hash = md.digest();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        for (int i = 0; i < hash.length; ++i) {
            nounce[8 + i] = hash[i];
            if (i == 23) break;
        }
        return new String(B64Code.encode((byte[])nounce));
    }

    private int checkNonce(String nonce, Request request) {
        try {
            byte[] n = B64Code.decode((char[])nonce.toCharArray());
            if (n.length != 24) {
                return -1;
            }
            long ts = 0L;
            long sk = this._nonceSecret;
            byte[] n2 = new byte[16];
            System.arraycopy(n, 0, n2, 0, 8);
            for (int i = 0; i < 8; ++i) {
                n2[8 + i] = (byte)(sk & 0xFFL);
                sk >>= 8;
                ts = (ts << 8) + (0xFFL & (long)n[7 - i]);
            }
            long age = request.getTimeStamp() - ts;
            if (LOG.isDebugEnabled()) {
                LOG.debug("age=" + age, new Object[0]);
            }
            byte[] hash = null;
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.reset();
                md.update(n2, 0, 16);
                hash = md.digest();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            for (int i = 0; i < 16; ++i) {
                if (n[i + 8] == hash[i]) continue;
                return -1;
            }
            if (this._maxNonceAge > 0L && (age < 0L || age > this._maxNonceAge)) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
            return -1;
        }
    }

    private static class Digest
    extends Credential {
        private static final long serialVersionUID = -2484639019549527724L;
        String method = null;
        String username = null;
        String realm = null;
        String nonce = null;
        String nc = null;
        String cnonce = null;
        String qop = null;
        String uri = null;
        String response = null;

        Digest(String m) {
            this.method = m;
        }

        public boolean check(Object credentials) {
            if (credentials instanceof char[]) {
                credentials = new String((char[])credentials);
            }
            String password = credentials instanceof String ? (String)credentials : credentials.toString();
            try {
                byte[] ha1;
                MessageDigest md = MessageDigest.getInstance("MD5");
                if (credentials instanceof Credential.MD5) {
                    ha1 = ((Credential.MD5)credentials).getDigest();
                } else {
                    md.update(this.username.getBytes("ISO-8859-1"));
                    md.update((byte)58);
                    md.update(this.realm.getBytes("ISO-8859-1"));
                    md.update((byte)58);
                    md.update(password.getBytes("ISO-8859-1"));
                    ha1 = md.digest();
                }
                md.reset();
                md.update(this.method.getBytes("ISO-8859-1"));
                md.update((byte)58);
                md.update(this.uri.getBytes("ISO-8859-1"));
                byte[] ha2 = md.digest();
                md.update(TypeUtil.toString((byte[])ha1, (int)16).getBytes("ISO-8859-1"));
                md.update((byte)58);
                md.update(this.nonce.getBytes("ISO-8859-1"));
                md.update((byte)58);
                md.update(this.nc.getBytes("ISO-8859-1"));
                md.update((byte)58);
                md.update(this.cnonce.getBytes("ISO-8859-1"));
                md.update((byte)58);
                md.update(this.qop.getBytes("ISO-8859-1"));
                md.update((byte)58);
                md.update(TypeUtil.toString((byte[])ha2, (int)16).getBytes("ISO-8859-1"));
                byte[] digest = md.digest();
                return TypeUtil.toString((byte[])digest, (int)16).equalsIgnoreCase(this.response);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                return false;
            }
        }

        public String toString() {
            return this.username + "," + this.response;
        }
    }
}

