/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.RoleInfo;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserDataConstraint;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelConfig;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.StringMap;
import org.eclipse.jetty.util.security.Constraint;

public class ConstraintSecurityHandler
extends SecurityHandler
implements ConstraintAware {
    private static final String ALL_METHODS = "*";
    private final List<ConstraintMapping> _constraintMappings = new CopyOnWriteArrayList<ConstraintMapping>();
    private final Set<String> _roles = new CopyOnWriteArraySet<String>();
    private final PathMap<Map<String, RoleInfo>> _constraintMap = new PathMap();
    private boolean _strict = true;

    public boolean isStrict() {
        return this._strict;
    }

    public void setStrict(boolean strict) {
        this._strict = strict;
    }

    @Override
    public List<ConstraintMapping> getConstraintMappings() {
        return this._constraintMappings;
    }

    @Override
    public Set<String> getRoles() {
        return this._roles;
    }

    public void setConstraintMappings(List<ConstraintMapping> constraintMappings) {
        this.setConstraintMappings(constraintMappings, null);
    }

    public void setConstraintMappings(ConstraintMapping[] constraintMappings) {
        this.setConstraintMappings(Arrays.asList(constraintMappings), null);
    }

    @Override
    public void setConstraintMappings(List<ConstraintMapping> constraintMappings, Set<String> roles) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._constraintMappings.clear();
        this._constraintMappings.addAll(constraintMappings);
        if (roles == null) {
            roles = new HashSet<String>();
            for (ConstraintMapping cm : constraintMappings) {
                String[] cmr = cm.getConstraint().getRoles();
                if (cmr == null) continue;
                for (String r : cmr) {
                    if (ALL_METHODS.equals(r)) continue;
                    roles.add(r);
                }
            }
        }
        this.setRoles(roles);
    }

    public void setRoles(Set<String> roles) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._roles.clear();
        this._roles.addAll(roles);
    }

    @Override
    public void addConstraintMapping(ConstraintMapping mapping) {
        this._constraintMappings.add(mapping);
        if (mapping.getConstraint() != null && mapping.getConstraint().getRoles() != null) {
            for (String role : mapping.getConstraint().getRoles()) {
                this.addRole(role);
            }
        }
        if (this.isStarted()) {
            this.processConstraintMapping(mapping);
        }
    }

    @Override
    public void addRole(String role) {
        boolean modified = this._roles.add(role);
        if (this.isStarted() && modified && this.isStrict()) {
            for (Map map : this._constraintMap.values()) {
                for (RoleInfo info : map.values()) {
                    if (!info.isAnyRole()) continue;
                    info.addRole(role);
                }
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        this._constraintMap.clear();
        if (this._constraintMappings != null) {
            for (ConstraintMapping mapping : this._constraintMappings) {
                this.processConstraintMapping(mapping);
            }
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._constraintMap.clear();
    }

    protected void processConstraintMapping(ConstraintMapping mapping) {
        RoleInfo roleInfo;
        RoleInfo allMethodsRoleInfo;
        Map mappings = (Map)this._constraintMap.get((Object)mapping.getPathSpec());
        if (mappings == null) {
            mappings = new StringMap();
            this._constraintMap.put(mapping.getPathSpec(), (Object)mappings);
        }
        if ((allMethodsRoleInfo = (RoleInfo)mappings.get(ALL_METHODS)) != null && allMethodsRoleInfo.isForbidden()) {
            return;
        }
        String httpMethod = mapping.getMethod();
        if (httpMethod == null) {
            httpMethod = ALL_METHODS;
        }
        if ((roleInfo = (RoleInfo)mappings.get(httpMethod)) == null) {
            roleInfo = new RoleInfo();
            mappings.put(httpMethod, roleInfo);
            if (allMethodsRoleInfo != null) {
                roleInfo.combine(allMethodsRoleInfo);
            }
        }
        if (roleInfo.isForbidden()) {
            return;
        }
        Constraint constraint = mapping.getConstraint();
        boolean forbidden = constraint.isForbidden();
        roleInfo.setForbidden(forbidden);
        if (forbidden) {
            if (httpMethod.equals(ALL_METHODS)) {
                mappings.clear();
                mappings.put(ALL_METHODS, roleInfo);
            }
        } else {
            UserDataConstraint userDataConstraint = UserDataConstraint.get(constraint.getDataConstraint());
            roleInfo.setUserDataConstraint(userDataConstraint);
            boolean checked = constraint.getAuthenticate();
            roleInfo.setChecked(checked);
            if (roleInfo.isChecked()) {
                if (constraint.isAnyRole()) {
                    if (this._strict) {
                        for (String string : this._roles) {
                            roleInfo.addRole(string);
                        }
                    } else {
                        roleInfo.setAnyRole(true);
                    }
                } else {
                    String[] newRoles;
                    for (String role : newRoles = constraint.getRoles()) {
                        if (this._strict && !this._roles.contains(role)) {
                            throw new IllegalArgumentException("Attempt to use undeclared role: " + role + ", known roles: " + this._roles);
                        }
                        roleInfo.addRole(role);
                    }
                }
            }
            if (httpMethod.equals(ALL_METHODS)) {
                for (Map.Entry entry : mappings.entrySet()) {
                    if (((String)entry.getKey()).equals(ALL_METHODS)) continue;
                    RoleInfo specific = (RoleInfo)entry.getValue();
                    specific.combine(roleInfo);
                }
            }
        }
    }

    @Override
    protected RoleInfo prepareConstraintInfo(String pathInContext, Request request) {
        Map mappings = (Map)this._constraintMap.match(pathInContext);
        if (mappings != null) {
            String httpMethod = request.getMethod();
            RoleInfo roleInfo = (RoleInfo)mappings.get(httpMethod);
            if (roleInfo == null) {
                roleInfo = (RoleInfo)mappings.get(ALL_METHODS);
            }
            return roleInfo;
        }
        return null;
    }

    @Override
    protected boolean checkUserDataPermissions(String pathInContext, Request request, Response response, RoleInfo roleInfo) throws IOException {
        if (roleInfo == null) {
            return true;
        }
        if (roleInfo.isForbidden()) {
            return false;
        }
        UserDataConstraint dataConstraint = roleInfo.getUserDataConstraint();
        if (dataConstraint == null || dataConstraint == UserDataConstraint.None) {
            return true;
        }
        HttpChannelConfig httpConfig = HttpChannel.getCurrentHttpChannel().getHttpChannelConfig();
        if (dataConstraint == UserDataConstraint.Confidential || dataConstraint == UserDataConstraint.Integral) {
            if (request.isSecure()) {
                return true;
            }
            if (httpConfig.getSecurePort() > 0) {
                String url = httpConfig.getSecureScheme() + "://" + request.getServerName() + ":" + httpConfig.getSecurePort() + request.getRequestURI();
                if (request.getQueryString() != null) {
                    url = url + "?" + request.getQueryString();
                }
                response.setContentLength(0);
                response.sendRedirect(url);
            } else {
                response.sendError(403, "!Secure");
            }
            request.setHandled(true);
            return false;
        }
        throw new IllegalArgumentException("Invalid dataConstraint value: " + (Object)((Object)dataConstraint));
    }

    @Override
    protected boolean isAuthMandatory(Request baseRequest, Response base_response, Object constraintInfo) {
        return constraintInfo != null && ((RoleInfo)constraintInfo).isChecked();
    }

    @Override
    protected boolean checkWebResourcePermissions(String pathInContext, Request request, Response response, Object constraintInfo, UserIdentity userIdentity) throws IOException {
        if (constraintInfo == null) {
            return true;
        }
        RoleInfo roleInfo = (RoleInfo)constraintInfo;
        if (!roleInfo.isChecked()) {
            return true;
        }
        if (roleInfo.isAnyRole() && request.getAuthType() != null) {
            return true;
        }
        for (String role : roleInfo.getRoles()) {
            if (!userIdentity.isUserInRole(role, null)) continue;
            return true;
        }
        return false;
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpBeans(out, indent, new Collection[]{Collections.singleton(this.getLoginService()), Collections.singleton(this.getIdentityService()), Collections.singleton(this.getAuthenticator()), Collections.singleton(this._roles), this._constraintMap.entrySet()});
    }
}

