/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.PathWatcher;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Credential;

public class PropertyUserStore
extends AbstractLifeCycle
implements PathWatcher.Listener {
    private static final Logger LOG = Log.getLogger(PropertyUserStore.class);
    private Path _configPath;
    private Resource _configResource;
    private PathWatcher pathWatcher;
    private boolean hotReload = false;
    private IdentityService _identityService = new DefaultIdentityService();
    private boolean _firstLoad = true;
    private final List<String> _knownUsers = new ArrayList<String>();
    private final Map<String, UserIdentity> _knownUserIdentities = new HashMap<String, UserIdentity>();
    private List<UserListener> _listeners;

    @Deprecated
    public String getConfig() {
        return this._configPath.toString();
    }

    @Deprecated
    public void setConfig(String configFile) {
        this.setConfigPath(configFile);
    }

    public Path getConfigPath() {
        return this._configPath;
    }

    public void setConfigPath(String configFile) {
        this._configPath = configFile == null ? null : new File(configFile).toPath();
    }

    public void setConfigPath(File configFile) {
        this._configPath = configFile.toPath();
    }

    public void setConfigPath(Path configPath) {
        this._configPath = configPath;
    }

    public UserIdentity getUserIdentity(String userName) {
        return this._knownUserIdentities.get(userName);
    }

    public Resource getConfigResource() throws IOException {
        if (this._configResource == null) {
            this._configResource = new PathResource(this._configPath);
        }
        return this._configResource;
    }

    public boolean isHotReload() {
        return this.hotReload;
    }

    public void setHotReload(boolean enable) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot set hot reload while user store is running");
        }
        this.hotReload = enable;
    }

    @Deprecated
    public void setRefreshInterval(int sec) {
    }

    @Deprecated
    public int getRefreshInterval() {
        return this.hotReload ? 1 : 0;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(((Object)((Object)this)).getClass().getName());
        s.append("[");
        s.append("users.count=").append(this._knownUsers.size());
        s.append("identityService=").append(this._identityService);
        s.append("]");
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUsers() throws IOException {
        if (this._configPath == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading " + (Object)((Object)this) + " from " + this._configPath, new Object[0]);
        }
        Properties properties = new Properties();
        if (this.getConfigResource().exists()) {
            properties.load(this.getConfigResource().getInputStream());
        }
        HashSet<String> known = new HashSet<String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String username = ((String)entry.getKey()).trim();
            String credentials = ((String)entry.getValue()).trim();
            String roles = null;
            int c = credentials.indexOf(44);
            if (c > 0) {
                roles = credentials.substring(c + 1).trim();
                credentials = credentials.substring(0, c).trim();
            }
            if (username == null || username.length() <= 0 || credentials == null || credentials.length() <= 0) continue;
            String[] roleArray = IdentityService.NO_ROLES;
            if (roles != null && roles.length() > 0) {
                roleArray = roles.split(",");
            }
            known.add(username);
            Credential credential = Credential.getCredential((String)credentials);
            MappedLoginService.KnownUser userPrincipal = new MappedLoginService.KnownUser(username, credential);
            Subject subject = new Subject();
            subject.getPrincipals().add(userPrincipal);
            subject.getPrivateCredentials().add(credential);
            if (roles != null) {
                for (String role : roleArray) {
                    subject.getPrincipals().add(new MappedLoginService.RolePrincipal(role));
                }
            }
            subject.setReadOnly();
            this._knownUserIdentities.put(username, this._identityService.newUserIdentity(subject, userPrincipal, roleArray));
            this.notifyUpdate(username, credential, roleArray);
        }
        List<String> list = this._knownUsers;
        synchronized (list) {
            if (!this._firstLoad) {
                for (String user : this._knownUsers) {
                    if (known.contains(user)) continue;
                    this._knownUserIdentities.remove(user);
                    this.notifyRemove(user);
                }
            }
            this._knownUsers.clear();
            this._knownUsers.addAll(known);
        }
        this._firstLoad = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded " + (Object)((Object)this) + " from " + this._configPath, new Object[0]);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.isHotReload() && this._configPath != null) {
            this.pathWatcher = new PathWatcher();
            this.pathWatcher.addFileWatch(this._configPath);
            this.pathWatcher.addListener((PathWatcher.Listener)this);
            this.pathWatcher.start();
        } else {
            this.loadUsers();
        }
    }

    public void onPathWatchEvent(PathWatcher.PathWatchEvent event) {
        try {
            this.loadUsers();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.pathWatcher != null) {
            this.pathWatcher.stop();
        }
    }

    private void notifyUpdate(String username, Credential credential, String[] roleArray) {
        if (this._listeners != null) {
            Iterator<UserListener> i = this._listeners.iterator();
            while (i.hasNext()) {
                i.next().update(username, credential, roleArray);
            }
        }
    }

    private void notifyRemove(String username) {
        if (this._listeners != null) {
            Iterator<UserListener> i = this._listeners.iterator();
            while (i.hasNext()) {
                i.next().remove(username);
            }
        }
    }

    public void registerUserListener(UserListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<UserListener>();
        }
        this._listeners.add(listener);
    }

    public static interface UserListener {
        public void update(String var1, Credential var2, String[] var3);

        public void remove(String var1);
    }
}

