/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.ssl.X509;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureRequestCustomizer
implements HttpConfiguration.Customizer {
    private static final Logger LOG = LoggerFactory.getLogger(SecureRequestCustomizer.class);
    public static final String JAKARTA_SERVLET_REQUEST_X_509_CERTIFICATE = "jakarta.servlet.request.X509Certificate";
    public static final String JAKARTA_SERVLET_REQUEST_CIPHER_SUITE = "jakarta.servlet.request.cipher_suite";
    public static final String JAKARTA_SERVLET_REQUEST_KEY_SIZE = "jakarta.servlet.request.key_size";
    public static final String JAKARTA_SERVLET_REQUEST_SSL_SESSION_ID = "jakarta.servlet.request.ssl_session_id";
    private String sslSessionAttribute = "org.eclipse.jetty.servlet.request.ssl_session";
    private boolean _sniRequired;
    private boolean _sniHostCheck;
    private long _stsMaxAge = -1L;
    private boolean _stsIncludeSubDomains;
    private HttpField _stsField;

    public SecureRequestCustomizer() {
        this(true);
    }

    public SecureRequestCustomizer(@Name(value="sniHostCheck") boolean sniHostCheck) {
        this(sniHostCheck, -1L, false);
    }

    public SecureRequestCustomizer(@Name(value="sniHostCheck") boolean sniHostCheck, @Name(value="stsMaxAgeSeconds") long stsMaxAgeSeconds, @Name(value="stsIncludeSubdomains") boolean stsIncludeSubdomains) {
        this(false, sniHostCheck, stsMaxAgeSeconds, stsIncludeSubdomains);
    }

    public SecureRequestCustomizer(@Name(value="sniRequired") boolean sniRequired, @Name(value="sniHostCheck") boolean sniHostCheck, @Name(value="stsMaxAgeSeconds") long stsMaxAgeSeconds, @Name(value="stsIncludeSubdomains") boolean stsIncludeSubdomains) {
        this._sniRequired = sniRequired;
        this._sniHostCheck = sniHostCheck;
        this._stsMaxAge = stsMaxAgeSeconds;
        this._stsIncludeSubDomains = stsIncludeSubdomains;
        this.formatSTS();
    }

    public boolean isSniHostCheck() {
        return this._sniHostCheck;
    }

    public void setSniHostCheck(boolean sniHostCheck) {
        this._sniHostCheck = sniHostCheck;
    }

    public boolean isSniRequired() {
        return this._sniRequired;
    }

    public void setSniRequired(boolean sniRequired) {
        this._sniRequired = sniRequired;
    }

    public long getStsMaxAge() {
        return this._stsMaxAge;
    }

    public void setStsMaxAge(long stsMaxAgeSeconds) {
        this._stsMaxAge = stsMaxAgeSeconds;
        this.formatSTS();
    }

    public void setStsMaxAge(long period, TimeUnit units) {
        this._stsMaxAge = units.toSeconds(period);
        this.formatSTS();
    }

    public boolean isStsIncludeSubDomains() {
        return this._stsIncludeSubDomains;
    }

    public void setStsIncludeSubDomains(boolean stsIncludeSubDomains) {
        this._stsIncludeSubDomains = stsIncludeSubDomains;
        this.formatSTS();
    }

    private void formatSTS() {
        this._stsField = this._stsMaxAge < 0L ? null : new PreEncodedHttpField(HttpHeader.STRICT_TRANSPORT_SECURITY, String.format("max-age=%d%s", this._stsMaxAge, this._stsIncludeSubDomains ? "; includeSubDomains" : ""));
    }

    @Override
    public void customize(Connector connector, HttpConfiguration channelConfig, Request request) {
        EndPoint endp = request.getHttpChannel().getEndPoint();
        if (endp instanceof SslConnection.DecryptedEndPoint) {
            SslConnection.DecryptedEndPoint sslEndp = (SslConnection.DecryptedEndPoint)endp;
            SslConnection sslConnection = sslEndp.getSslConnection();
            SSLEngine sslEngine = sslConnection.getSSLEngine();
            this.customize(sslEngine, request);
            request.setHttpURI((HttpURI)HttpURI.build((HttpURI)request.getHttpURI()).scheme(HttpScheme.HTTPS));
        } else if (endp instanceof ProxyConnectionFactory.ProxyEndPoint) {
            ProxyConnectionFactory.ProxyEndPoint proxy = (ProxyConnectionFactory.ProxyEndPoint)endp;
            if (request.getHttpURI().getScheme() == null && proxy.getAttribute("TLS_VERSION") != null) {
                request.setHttpURI((HttpURI)HttpURI.build((HttpURI)request.getHttpURI()).scheme(HttpScheme.HTTPS));
            }
        }
        if (HttpScheme.HTTPS.is(request.getScheme())) {
            this.customizeSecure(request);
        }
    }

    protected void customize(SSLEngine sslEngine, Request request) {
        SSLSession sslSession = sslEngine.getSession();
        if (this._sniHostCheck || this._sniRequired) {
            X509 x509 = (X509)sslSession.getValue("org.eclipse.jetty.util.ssl.snix509");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Host {} with SNI {}", (Object)request.getServerName(), (Object)x509);
            }
            if (x509 == null) {
                if (this._sniRequired) {
                    throw new BadMessageException(400, "SNI required");
                }
            } else if (this._sniHostCheck && !x509.matches(request.getServerName())) {
                throw new BadMessageException(400, "Host does not match SNI");
            }
        }
        request.setAttributes((Attributes)new SslAttributes(request, sslSession, request.getAttributes()));
    }

    protected void customizeSecure(Request request) {
        request.setSecure(true);
        if (this._stsField != null) {
            request.getResponse().getHttpFields().add(this._stsField);
        }
    }

    private X509Certificate[] getCertChain(Request request, SSLSession sslSession) {
        SslContextFactory.Server sslContextFactory;
        Connector connector = request.getHttpChannel().getConnector();
        SslConnectionFactory sslConnectionFactory = connector.getConnectionFactory(SslConnectionFactory.class);
        if (sslConnectionFactory != null && (sslContextFactory = sslConnectionFactory.getSslContextFactory()) != null) {
            return sslContextFactory.getX509CertChain(sslSession);
        }
        return SslContextFactory.getCertChain((SSLSession)sslSession);
    }

    public void setSslSessionAttribute(String attribute) {
        this.sslSessionAttribute = attribute;
    }

    public String getSslSessionAttribute() {
        return this.sslSessionAttribute;
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }

    private class SslAttributes
    extends Attributes.Wrapper {
        private final Request _request;
        private final SSLSession _session;

        public SslAttributes(Request request, SSLSession sslSession, Attributes attributes) {
            super(attributes);
            this._request = request;
            this._session = sslSession;
        }

        public Object getAttribute(String name) {
            block16: {
                Object value = this._attributes.getAttribute(name);
                if (value != null) {
                    return value;
                }
                try {
                    switch (name) {
                        case "jakarta.servlet.request.X509Certificate": {
                            return SecureRequestCustomizer.this.getCertChain(this._request, this._session);
                        }
                        case "jakarta.servlet.request.cipher_suite": {
                            return this._session.getCipherSuite();
                        }
                        case "jakarta.servlet.request.key_size": {
                            return SslContextFactory.deduceKeyLength((String)this._session.getCipherSuite());
                        }
                        case "jakarta.servlet.request.ssl_session_id": {
                            return TypeUtil.toHexString((byte[])this._session.getId());
                        }
                    }
                    String sessionAttribute = SecureRequestCustomizer.this.getSslSessionAttribute();
                    if (!StringUtil.isEmpty((String)sessionAttribute) && sessionAttribute.equals(name)) {
                        return this._session;
                    }
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block16;
                    LOG.debug("Unable to get secure details ", (Throwable)e);
                }
            }
            return null;
        }

        public Set<String> getAttributeNameSet() {
            HashSet<String> names = new HashSet<String>(this._attributes.getAttributeNameSet());
            names.add(SecureRequestCustomizer.JAKARTA_SERVLET_REQUEST_X_509_CERTIFICATE);
            names.add(SecureRequestCustomizer.JAKARTA_SERVLET_REQUEST_CIPHER_SUITE);
            names.add(SecureRequestCustomizer.JAKARTA_SERVLET_REQUEST_KEY_SIZE);
            names.add(SecureRequestCustomizer.JAKARTA_SERVLET_REQUEST_SSL_SESSION_ID);
            String sessionAttribute = SecureRequestCustomizer.this.getSslSessionAttribute();
            if (!StringUtil.isEmpty((String)sessionAttribute)) {
                names.add(sessionAttribute);
            }
            return names;
        }
    }
}

