/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.logging.StacklessLogging;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractHttpTest {
    private static final Set<String> __noBodyCodes = new HashSet<String>(Arrays.asList("100", "101", "102", "204", "304"));
    protected static Server server;
    protected static ServerConnector connector;
    private StacklessLogging stacklessChannelLogging;

    @BeforeEach
    public void setUp() throws Exception {
        server = new Server();
        connector = new ServerConnector(server, null, null, (ByteBufferPool)new ArrayByteBufferPool(64, 2048, 65536), 1, 1, new ConnectionFactory[]{new HttpConnectionFactory()});
        connector.setIdleTimeout(100000L);
        server.addConnector((Connector)connector);
        this.stacklessChannelLogging = new StacklessLogging(new Class[]{HttpChannel.class});
    }

    @AfterEach
    public void tearDown() throws Exception {
        server.stop();
        this.stacklessChannelLogging.close();
    }

    protected HttpTester.Response executeRequest(HttpVersion httpVersion) throws URISyntaxException, IOException {
        try (Socket socket = new Socket("localhost", connector.getLocalPort());){
            socket.setSoTimeout((int)connector.getIdleTimeout());
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
            try {
                writer.write("GET / " + httpVersion.asString() + "\r\n");
                writer.write("Host: localhost\r\n");
                writer.write("\r\n");
                writer.flush();
                HttpTester.Response response = new HttpTester.Response();
                HttpTester.Input input = HttpTester.from((InputStream)socket.getInputStream());
                HttpTester.parseResponse((HttpTester.Input)input, (HttpTester.Response)response);
                if (httpVersion.is("HTTP/1.1") && response.isComplete() && response.get("content-length") == null && response.get("transfer-encoding") == null && !__noBodyCodes.contains(response.getStatus())) {
                    MatcherAssert.assertThat((String)"If HTTP/1.1 response doesn't contain transfer-encoding or content-length headers, it should contain connection:close", (Object)response.get("connection"), (Matcher)Matchers.is((Object)"close"));
                }
                HttpTester.Response response2 = response;
                writer.close();
                return response2;
            }
            catch (Throwable throwable) {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    protected class ThrowExceptionOnDemandHandler
    extends AbstractHandler {
        private final boolean throwException;
        private volatile Throwable failure;

        protected ThrowExceptionOnDemandHandler(boolean throwException) {
            this.throwException = throwException;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (this.throwException) {
                throw new TestCommitException();
            }
        }

        protected void markFailed(Throwable x) {
            this.failure = x;
        }

        public Throwable failure() {
            return this.failure;
        }
    }

    protected static class TestCommitException
    extends IllegalStateException {
        public TestCommitException() {
            super("Thrown by test");
        }
    }
}

