/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.jetty.server.ClassLoaderDump;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.Dumpable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class ClassLoaderDumpTest {
    @Test
    public void testSimple() throws Exception {
        Server server = new Server();
        ClassLoader loader = new ClassLoader(){

            public String toString() {
                return "SimpleLoader";
            }
        };
        server.addBean((Object)new ClassLoaderDump(loader));
        StringBuilder out = new StringBuilder();
        server.dump((Appendable)out);
        String dump = out.toString();
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)"+- SimpleLoader"));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)("+> " + Server.class.getClassLoader())));
    }

    @Test
    public void testParent() throws Exception {
        Server server = new Server();
        ClassLoader loader = new ClassLoader(Server.class.getClassLoader()){

            public String toString() {
                return "ParentedLoader";
            }
        };
        server.addBean((Object)new ClassLoaderDump(loader));
        StringBuilder out = new StringBuilder();
        server.dump((Appendable)out);
        String dump = out.toString();
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)"+- ParentedLoader"));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)("|  +> Server loader: " + Server.class.getClassLoader())));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)("+> " + Server.class.getClassLoader())));
    }

    @Test
    public void testNested() throws Exception {
        Server server = new Server();
        ClassLoader middleLoader = new ClassLoader(Server.class.getClassLoader()){

            public String toString() {
                return "MiddleLoader";
            }
        };
        ClassLoader loader = new ClassLoader(middleLoader){

            public String toString() {
                return "TopLoader";
            }
        };
        server.addBean((Object)new ClassLoaderDump(loader));
        StringBuilder out = new StringBuilder();
        server.dump((Appendable)out);
        String dump = out.toString();
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)"+- TopLoader"));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)"|  +> MiddleLoader"));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)("|     +> Server loader: " + Server.class.getClassLoader())));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)("+> " + Server.class.getClassLoader())));
    }

    @Test
    public void testDumpable() throws Exception {
        Server server = new Server();
        DumpableClassLoader middleLoader = new DumpableClassLoader(Server.class.getClassLoader());
        ClassLoader loader = new ClassLoader((ClassLoader)middleLoader){

            public String toString() {
                return "TopLoader";
            }
        };
        server.addBean((Object)new ClassLoaderDump(loader));
        StringBuilder out = new StringBuilder();
        server.dump((Appendable)out);
        String dump = out.toString();
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)"+- TopLoader"));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)"|  +> DumpableClassLoader"));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)("|    +> " + Server.class.getClassLoader()))));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)("+> " + Server.class.getClassLoader())));
    }

    @Test
    public void testUrlClassLoaders() throws Exception {
        Server server = new Server();
        URLClassLoader middleLoader = new URLClassLoader(new URL[]{new URL("file:/one"), new URL("file:/two"), new URL("file:/three")}, Server.class.getClassLoader()){

            public String toString() {
                return "MiddleLoader";
            }
        };
        URLClassLoader loader = new URLClassLoader(new URL[]{new URL("file:/ONE"), new URL("file:/TWO"), new URL("file:/THREE")}, (ClassLoader)middleLoader){

            public String toString() {
                return "TopLoader";
            }
        };
        server.addBean((Object)new ClassLoaderDump((ClassLoader)loader));
        StringBuilder out = new StringBuilder();
        server.dump((Appendable)out);
        String dump = out.toString();
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)"+- TopLoader"));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)"|  |  +> file:/ONE"));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)"|  |  +> file:/TWO"));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)"|  |  +> file:/THREE"));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)"|  +> MiddleLoader"));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)"|     |  +> file:/one"));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)"|     |  +> file:/two"));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)"|     |  +> file:/three"));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)("|     +> " + Server.class.getClassLoader())));
        MatcherAssert.assertThat((Object)dump, (Matcher)Matchers.containsString((String)("+> " + Server.class.getClassLoader())));
    }

    public static class DumpableClassLoader
    extends ClassLoader
    implements Dumpable {
        public DumpableClassLoader(ClassLoader parent) {
            super(parent);
        }

        public String dump() {
            return "DumpableClassLoader";
        }

        public void dump(Appendable out, String indent) throws IOException {
            out.append(this.dump()).append('\n');
        }

        public String toString() {
            return "DumpableClassLoader";
        }
    }
}

