/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import jakarta.servlet.http.Cookie;
import org.eclipse.jetty.server.Cookies;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class CookiesTest {
    @Test
    public void testEmpty() {
        Cookies cutter = new Cookies();
        MatcherAssert.assertThat((Object)cutter.getCookies().length, (Matcher)Matchers.is((Object)0));
        cutter.reset();
        MatcherAssert.assertThat((Object)cutter.getCookies().length, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testCacheHit() {
        Cookies cutter = new Cookies();
        cutter.addCookieField("nameA0=A0; nameA1=A1");
        cutter.addCookieField("nameB0=B0; nameB1=B1");
        Cookie[] cookiesX = cutter.getCookies();
        MatcherAssert.assertThat((Object)cookiesX.length, (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)cookiesX[0].getName(), (Matcher)Matchers.is((Object)"nameA0"));
        MatcherAssert.assertThat((Object)cookiesX[3].getValue(), (Matcher)Matchers.is((Object)"B1"));
        cutter.reset();
        cutter.addCookieField("nameA0=A0; nameA1=A1");
        cutter.addCookieField("nameB0=B0; nameB1=B1");
        Cookie[] cookiesY = cutter.getCookies();
        MatcherAssert.assertThat((Object)cookiesY.length, (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)cookiesY[0].getName(), (Matcher)Matchers.is((Object)"nameA0"));
        MatcherAssert.assertThat((Object)cookiesY[3].getValue(), (Matcher)Matchers.is((Object)"B1"));
        MatcherAssert.assertThat((Object)cookiesX, (Matcher)Matchers.sameInstance((Object)cookiesY));
    }

    @Test
    public void testCacheMiss() {
        Cookies cutter = new Cookies();
        cutter.addCookieField("nameA0=A0; nameA1=A1");
        cutter.addCookieField("nameB0=B0; nameB1=B1");
        Cookie[] cookiesX = cutter.getCookies();
        MatcherAssert.assertThat((Object)cookiesX.length, (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)cookiesX[0].getName(), (Matcher)Matchers.is((Object)"nameA0"));
        MatcherAssert.assertThat((Object)cookiesX[3].getValue(), (Matcher)Matchers.is((Object)"B1"));
        cutter.reset();
        cutter.addCookieField("nameA0=A0; nameA1=A1");
        cutter.addCookieField("nameC0=C0; nameC1=C1");
        Cookie[] cookiesY = cutter.getCookies();
        MatcherAssert.assertThat((Object)cookiesY.length, (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)cookiesY[0].getName(), (Matcher)Matchers.is((Object)"nameA0"));
        MatcherAssert.assertThat((Object)cookiesY[3].getValue(), (Matcher)Matchers.is((Object)"C1"));
        MatcherAssert.assertThat((Object)cookiesX, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)cookiesY)));
    }

    @Test
    public void testCacheUnder() {
        Cookies cutter = new Cookies();
        cutter.addCookieField("nameA0=A0; nameA1=A1");
        cutter.addCookieField("nameB0=B0; nameB1=B1");
        Cookie[] cookiesX = cutter.getCookies();
        MatcherAssert.assertThat((Object)cookiesX.length, (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)cookiesX[0].getName(), (Matcher)Matchers.is((Object)"nameA0"));
        MatcherAssert.assertThat((Object)cookiesX[3].getValue(), (Matcher)Matchers.is((Object)"B1"));
        cutter.reset();
        cutter.addCookieField("nameA0=A0; nameA1=A1");
        Cookie[] cookiesY = cutter.getCookies();
        MatcherAssert.assertThat((Object)cookiesY.length, (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)cookiesY[0].getName(), (Matcher)Matchers.is((Object)"nameA0"));
        MatcherAssert.assertThat((Object)cookiesY[1].getValue(), (Matcher)Matchers.is((Object)"A1"));
        MatcherAssert.assertThat((Object)cookiesX, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)cookiesY)));
    }

    @Test
    public void testCacheOver() {
        Cookies cutter = new Cookies();
        cutter.addCookieField("nameA0=A0; nameA1=A1");
        cutter.addCookieField("nameB0=B0; nameB1=B1");
        Cookie[] cookiesX = cutter.getCookies();
        MatcherAssert.assertThat((Object)cookiesX.length, (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)cookiesX[0].getName(), (Matcher)Matchers.is((Object)"nameA0"));
        MatcherAssert.assertThat((Object)cookiesX[3].getValue(), (Matcher)Matchers.is((Object)"B1"));
        cutter.reset();
        cutter.addCookieField("nameA0=A0; nameA1=A1");
        cutter.addCookieField("nameB0=B0; nameB1=B1");
        cutter.addCookieField("nameC0=C0; nameC1=C1");
        Cookie[] cookiesY = cutter.getCookies();
        MatcherAssert.assertThat((Object)cookiesY.length, (Matcher)Matchers.is((Object)6));
        MatcherAssert.assertThat((Object)cookiesY[0].getName(), (Matcher)Matchers.is((Object)"nameA0"));
        MatcherAssert.assertThat((Object)cookiesY[5].getValue(), (Matcher)Matchers.is((Object)"C1"));
        MatcherAssert.assertThat((Object)cookiesX, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)cookiesY)));
    }

    @Test
    public void testCacheReset() {
        Cookies cutter = new Cookies();
        cutter.addCookieField("nameA0=A0; nameA1=A1");
        cutter.addCookieField("nameB0=B0; nameB1=B1");
        Cookie[] cookiesX = cutter.getCookies();
        MatcherAssert.assertThat((Object)cookiesX.length, (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)cookiesX[0].getName(), (Matcher)Matchers.is((Object)"nameA0"));
        MatcherAssert.assertThat((Object)cookiesX[3].getValue(), (Matcher)Matchers.is((Object)"B1"));
        cutter.reset();
        MatcherAssert.assertThat((Object)cutter.getCookies().length, (Matcher)Matchers.is((Object)0));
        cutter.addCookieField("nameA0=A0; nameA1=A1");
        cutter.addCookieField("nameB0=B0; nameB1=B1");
        Cookie[] cookiesY = cutter.getCookies();
        MatcherAssert.assertThat((Object)cookiesY.length, (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)cookiesY[0].getName(), (Matcher)Matchers.is((Object)"nameA0"));
        MatcherAssert.assertThat((Object)cookiesY[3].getValue(), (Matcher)Matchers.is((Object)"B1"));
        MatcherAssert.assertThat((Object)cookiesX, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)cookiesY)));
    }

    @Test
    public void testSet() {
        Cookies cutter = new Cookies();
        cutter.setCookies(new Cookie[]{new Cookie("nameA0", "A0"), new Cookie("nameA1", "A1"), new Cookie("nameB0", "B0"), new Cookie("nameB1", "B1")});
        Cookie[] cookiesX = cutter.getCookies();
        MatcherAssert.assertThat((Object)cookiesX.length, (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)cookiesX[0].getName(), (Matcher)Matchers.is((Object)"nameA0"));
        MatcherAssert.assertThat((Object)cookiesX[3].getValue(), (Matcher)Matchers.is((Object)"B1"));
        cutter.reset();
        MatcherAssert.assertThat((Object)cutter.getCookies().length, (Matcher)Matchers.is((Object)0));
    }
}

