/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DumpHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.TimerScheduler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomResourcesMonitorTest {
    Server _server;
    ServerConnector _connector;
    FileOnDirectoryMonitor _fileOnDirectoryMonitor;
    Path _monitoredPath;
    LowResourceMonitor _lowResourceMonitor;

    @BeforeEach
    public void before() throws Exception {
        this._server = new Server();
        this._server.addBean((Object)new TimerScheduler());
        this._connector = new ServerConnector(this._server);
        this._connector.setPort(0);
        this._connector.setIdleTimeout(35000L);
        this._server.addConnector((Connector)this._connector);
        this._server.setHandler((Handler)new DumpHandler());
        this._monitoredPath = Files.createTempDirectory("jetty_test", new FileAttribute[0]);
        this._fileOnDirectoryMonitor = new FileOnDirectoryMonitor(this._monitoredPath);
        this._lowResourceMonitor = new LowResourceMonitor(this._server);
        this._server.addBean((Object)this._lowResourceMonitor);
        this._lowResourceMonitor.addLowResourceCheck((LowResourceMonitor.LowResourceCheck)this._fileOnDirectoryMonitor);
        this._server.start();
    }

    @AfterEach
    public void after() throws Exception {
        this._server.stop();
    }

    @Test
    public void testFileOnDirectoryMonitor() throws Exception {
        int monitorPeriod = this._lowResourceMonitor.getPeriod();
        int lowResourcesIdleTimeout = this._lowResourceMonitor.getLowResourcesIdleTimeout();
        MatcherAssert.assertThat((Object)lowResourcesIdleTimeout, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(monitorPeriod)));
        int maxLowResourcesTime = 5 * monitorPeriod;
        this._lowResourceMonitor.setMaxLowResourcesTime(maxLowResourcesTime);
        Assertions.assertFalse((boolean)this._fileOnDirectoryMonitor.isLowOnResources());
        try (Socket socket0 = new Socket("localhost", this._connector.getLocalPort());){
            Path tmpFile = Files.createTempFile(this._monitoredPath, "yup", ".tmp", new FileAttribute[0]);
            Files.write(tmpFile, "foobar".getBytes(), new OpenOption[0]);
            Thread.sleep(2 * monitorPeriod);
            Assertions.assertTrue((boolean)this._fileOnDirectoryMonitor.isLowOnResources());
            Assertions.assertEquals((int)-1, (int)socket0.getInputStream().read());
            try (Socket socket1 = new Socket("localhost", this._connector.getLocalPort());){
                socket1.setSoTimeout(1);
                InputStream input1 = socket1.getInputStream();
                Assertions.assertTrue((boolean)this._fileOnDirectoryMonitor.isLowOnResources());
                Assertions.assertThrows(SocketTimeoutException.class, () -> input1.read());
                Thread.sleep(2 * lowResourcesIdleTimeout);
                Assertions.assertTrue((boolean)this._fileOnDirectoryMonitor.isLowOnResources());
                Assertions.assertThrows(SocketTimeoutException.class, () -> input1.read());
                Files.delete(tmpFile);
                Thread.sleep(maxLowResourcesTime);
                Assertions.assertFalse((boolean)this._fileOnDirectoryMonitor.isLowOnResources());
            }
        }
    }

    static class FileOnDirectoryMonitor
    implements LowResourceMonitor.LowResourceCheck {
        private static final Logger LOG = LoggerFactory.getLogger(FileOnDirectoryMonitor.class);
        private final Path _pathToMonitor;
        private String reason;

        public FileOnDirectoryMonitor(Path pathToMonitor) {
            this._pathToMonitor = pathToMonitor;
        }

        public boolean isLowOnResources() {
            try {
                Stream<Path> paths = Files.list(this._pathToMonitor);
                List content = paths.collect(Collectors.toList());
                if (!content.isEmpty()) {
                    this.reason = "directory not empty so enable low resources";
                    return true;
                }
            }
            catch (IOException e) {
                LOG.info("ignore issue looking at directory content", (Throwable)e);
            }
            return false;
        }

        public String getReason() {
            return this.reason;
        }

        public String toString() {
            return this.getClass().getName();
        }
    }
}

