/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.HttpServerTestBase;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.junit.jupiter.api.BeforeEach;

public class DelayedServerTest
extends HttpServerTestBase {
    @BeforeEach
    public void init() throws Exception {
        this.startServer(new ServerConnector(this._server, new ConnectionFactory[]{new HttpConnectionFactory(){

            public Connection newConnection(Connector connector, EndPoint endPoint) {
                return this.configure((AbstractConnection)new DelayedHttpConnection(this.getHttpConfiguration(), connector, endPoint), connector, endPoint);
            }
        }}));
    }

    private static class DelayedCallback
    extends Callback.Nested {
        final ThreadPool pool;

        public DelayedCallback(Callback callback, ThreadPool threadPool) {
            super(callback);
            this.pool = threadPool;
        }

        public void succeeded() {
            this.pool.execute(() -> {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    super.succeeded();
                }
            });
        }

        public void failed(Throwable x) {
            this.pool.execute(() -> {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    super.failed(x);
                }
            });
        }
    }

    private static class DelayedHttpConnection
    extends HttpConnection {
        public DelayedHttpConnection(HttpConfiguration config, Connector connector, EndPoint endPoint) {
            super(config, connector, endPoint, false);
        }

        public void send(MetaData.Request request, MetaData.Response response, ByteBuffer content, boolean lastContent, Callback callback) {
            DelayedCallback delay = new DelayedCallback(callback, this.getServer().getThreadPool());
            super.send(request, response, content, lastContent, (Callback)delay);
        }
    }
}

