/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DetectorConnectionFactory;
import org.eclipse.jetty.server.DumpHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DetectorConnectionTest {
    private Server _server;

    private static String inputStreamToString(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.US_ASCII));
        while (true) {
            String line;
            if ((line = reader.readLine()) == null) {
                if (sb.length() == 0) break;
                sb.deleteCharAt(sb.length() - 1);
                break;
            }
            sb.append(line).append('\n');
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    private String getResponse(String request) throws Exception {
        return this.getResponse(new byte[][]{request.getBytes(StandardCharsets.US_ASCII)});
    }

    private String getResponse(byte[] ... requests) throws Exception {
        try (Socket socket = new Socket(this._server.getURI().getHost(), this._server.getURI().getPort());){
            for (byte[] request : requests) {
                socket.getOutputStream().write(request);
            }
            String string = DetectorConnectionTest.inputStreamToString(socket.getInputStream());
            return string;
        }
    }

    private String getResponseOverSsl(String request) throws Exception {
        String keystore = MavenTestingUtils.getTestResourceFile((String)"keystore.p12").getAbsolutePath();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystore);
        sslContextFactory.setKeyStorePassword("storepwd");
        sslContextFactory.start();
        SSLSocketFactory socketFactory = sslContextFactory.getSslContext().getSocketFactory();
        try {
            String string;
            block9: {
                Socket socket = socketFactory.createSocket(this._server.getURI().getHost(), this._server.getURI().getPort());
                try {
                    socket.getOutputStream().write(request.getBytes(StandardCharsets.US_ASCII));
                    string = DetectorConnectionTest.inputStreamToString(socket.getInputStream());
                    if (socket == null) break block9;
                }
                catch (Throwable throwable) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                socket.close();
            }
            return string;
        }
        finally {
            sslContextFactory.stop();
        }
    }

    private void start(ConnectionFactory ... connectionFactories) throws Exception {
        this._server = new Server();
        this._server.addConnector((Connector)new ServerConnector(this._server, 1, 1, connectionFactories));
        this._server.setHandler((Handler)new DumpHandler());
        this._server.start();
    }

    @AfterEach
    public void destroy() throws Exception {
        if (this._server != null) {
            this._server.stop();
        }
    }

    @Test
    public void testConnectionClosedDuringDetection() throws Exception {
        HttpConnectionFactory http = new HttpConnectionFactory();
        ProxyConnectionFactory proxy = new ProxyConnectionFactory(http.getProtocol());
        DetectorConnectionFactory detector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{proxy});
        this.start(new ConnectionFactory[]{detector, http});
        try (Socket socket = new Socket(this._server.getURI().getHost(), this._server.getURI().getPort());){
            socket.getOutputStream().write("PR".getBytes(StandardCharsets.US_ASCII));
            Thread.sleep(100L);
            socket.getOutputStream().write("OX".getBytes(StandardCharsets.US_ASCII));
            socket.getOutputStream().close();
            Assertions.assertThrows(SocketException.class, () -> socket.getInputStream().read());
        }
    }

    @Test
    public void testConnectionClosedDuringProxyV1Handling() throws Exception {
        HttpConnectionFactory http = new HttpConnectionFactory();
        ProxyConnectionFactory proxy = new ProxyConnectionFactory(http.getProtocol());
        DetectorConnectionFactory detector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{proxy});
        this.start(new ConnectionFactory[]{detector, http});
        try (Socket socket = new Socket(this._server.getURI().getHost(), this._server.getURI().getPort());){
            socket.getOutputStream().write("PROXY".getBytes(StandardCharsets.US_ASCII));
            Thread.sleep(100L);
            socket.getOutputStream().write(" ".getBytes(StandardCharsets.US_ASCII));
            socket.getOutputStream().close();
            Assertions.assertThrows(SocketException.class, () -> socket.getInputStream().read());
        }
    }

    @Test
    public void testConnectionClosedDuringProxyV2HandlingFixedLengthPart() throws Exception {
        HttpConnectionFactory http = new HttpConnectionFactory();
        ProxyConnectionFactory proxy = new ProxyConnectionFactory(http.getProtocol());
        DetectorConnectionFactory detector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{proxy});
        this.start(new ConnectionFactory[]{detector, http});
        try (Socket socket = new Socket(this._server.getURI().getHost(), this._server.getURI().getPort());){
            socket.getOutputStream().write(TypeUtil.fromHexString((String)"0D0A0D0A000D0A515549540A"));
            Thread.sleep(100L);
            socket.getOutputStream().write(TypeUtil.fromHexString((String)"21"));
            socket.getOutputStream().close();
            Assertions.assertThrows(SocketException.class, () -> socket.getInputStream().read());
        }
    }

    @Test
    public void testConnectionClosedDuringProxyV2HandlingDynamicLengthPart() throws Exception {
        HttpConnectionFactory http = new HttpConnectionFactory();
        ProxyConnectionFactory proxy = new ProxyConnectionFactory(http.getProtocol());
        DetectorConnectionFactory detector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{proxy});
        this.start(new ConnectionFactory[]{detector, http});
        try (Socket socket = new Socket(this._server.getURI().getHost(), this._server.getURI().getPort());){
            socket.getOutputStream().write(TypeUtil.fromHexString((String)"0D0A0D0A000D0A515549540A2111000C"));
            Thread.sleep(100L);
            socket.getOutputStream().write(TypeUtil.fromHexString((String)"C0A80001"));
            socket.getOutputStream().close();
            Assertions.assertThrows(SocketException.class, () -> socket.getInputStream().read());
        }
    }

    @Test
    public void testDetectingSslProxyToHttpNoSslWithProxy() throws Exception {
        String keystore = MavenTestingUtils.getTestResourceFile((String)"keystore.p12").getAbsolutePath();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystore);
        sslContextFactory.setKeyStorePassword("storepwd");
        HttpConnectionFactory http = new HttpConnectionFactory();
        ProxyConnectionFactory proxy = new ProxyConnectionFactory(http.getProtocol());
        SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, http.getProtocol());
        DetectorConnectionFactory detector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{ssl, proxy});
        this.start(new ConnectionFactory[]{detector, http});
        String request = "PROXY TCP 1.2.3.4 5.6.7.8 111 222\r\nGET /path HTTP/1.1\nHost: server:80\nConnection: close\n\n";
        String response = this.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/path"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"local=5.6.7.8:222"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"remote=1.2.3.4:111"));
    }

    @Test
    public void testDetectingSslProxyToHttpWithSslNoProxy() throws Exception {
        String keystore = MavenTestingUtils.getTestResourceFile((String)"keystore.p12").getAbsolutePath();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystore);
        sslContextFactory.setKeyStorePassword("storepwd");
        HttpConnectionFactory http = new HttpConnectionFactory();
        ProxyConnectionFactory proxy = new ProxyConnectionFactory(http.getProtocol());
        SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, http.getProtocol());
        DetectorConnectionFactory detector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{ssl, proxy});
        this.start(new ConnectionFactory[]{detector, http});
        String request = "GET /path HTTP/1.1\nHost: server:80\nConnection: close\n\n";
        String response = this.getResponseOverSsl(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200"));
    }

    @Test
    public void testDetectingSslProxyToHttpWithSslWithProxy() throws Exception {
        String keystore = MavenTestingUtils.getTestResourceFile((String)"keystore.p12").getAbsolutePath();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystore);
        sslContextFactory.setKeyStorePassword("storepwd");
        HttpConnectionFactory http = new HttpConnectionFactory();
        ProxyConnectionFactory proxy = new ProxyConnectionFactory(http.getProtocol());
        SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, http.getProtocol());
        DetectorConnectionFactory detector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{ssl, proxy});
        this.start(new ConnectionFactory[]{detector, http});
        String request = "PROXY TCP 1.2.3.4 5.6.7.8 111 222\r\nGET /path HTTP/1.1\nHost: server:80\nConnection: close\n\n";
        String response = this.getResponseOverSsl(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 400"));
    }

    @Test
    public void testDetectionUnsuccessfulUpgradesToNextProtocol() throws Exception {
        String keystore = MavenTestingUtils.getTestResourceFile((String)"keystore.p12").getAbsolutePath();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystore);
        sslContextFactory.setKeyStorePassword("storepwd");
        HttpConnectionFactory http = new HttpConnectionFactory();
        ProxyConnectionFactory proxy = new ProxyConnectionFactory(http.getProtocol());
        SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, http.getProtocol());
        DetectorConnectionFactory detector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{ssl, proxy});
        this.start(new ConnectionFactory[]{detector, http});
        String request = "GET /path HTTP/1.1\nHost: server:80\nConnection: close\n\n";
        String response = this.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200"));
    }

    @Test
    public void testDetectorToNextDetector() throws Exception {
        String keystore = MavenTestingUtils.getTestResourceFile((String)"keystore.p12").getAbsolutePath();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystore);
        sslContextFactory.setKeyStorePassword("storepwd");
        HttpConnectionFactory http = new HttpConnectionFactory();
        ProxyConnectionFactory proxy = new ProxyConnectionFactory(http.getProtocol());
        DetectorConnectionFactory proxyDetector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{proxy});
        SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, proxyDetector.getProtocol());
        DetectorConnectionFactory sslDetector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{ssl});
        this.start(new ConnectionFactory[]{sslDetector, proxyDetector, http});
        String request = "PROXY TCP 1.2.3.4 5.6.7.8 111 222\r\nGET /path HTTP/1.1\nHost: server:80\nConnection: close\n\n";
        String response = this.getResponseOverSsl(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/path"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"local=5.6.7.8:222"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"remote=1.2.3.4:111"));
    }

    @Test
    public void testDetectorWithDetectionUnsuccessful() throws Exception {
        final AtomicBoolean detectionSuccessful = new AtomicBoolean(true);
        ProxyConnectionFactory proxy = new ProxyConnectionFactory(HttpVersion.HTTP_1_1.asString());
        DetectorConnectionFactory detector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{proxy}){

            protected void nextProtocol(Connector connector, EndPoint endPoint, ByteBuffer buffer) {
                if (!detectionSuccessful.compareAndSet(true, false)) {
                    throw new AssertionError((Object)"DetectionUnsuccessful callback should only have been called once");
                }
                connector.getByteBufferPool().release(buffer);
                Callback.Completable completable = new Callback.Completable();
                endPoint.write((Callback)completable, new ByteBuffer[]{ByteBuffer.wrap("No upgrade for you".getBytes(StandardCharsets.US_ASCII))});
                completable.whenComplete((r, x) -> endPoint.close());
            }
        };
        HttpConnectionFactory http = new HttpConnectionFactory();
        this.start(new ConnectionFactory[]{detector, http});
        String request = "GET /path HTTP/1.1\nHost: server:80\nConnection: close\n\n";
        String response = this.getResponse(request);
        Assertions.assertEquals((Object)"No upgrade for you", (Object)response);
        Assertions.assertFalse((boolean)detectionSuccessful.get());
    }

    @Test
    public void testDetectorWithProxyThatHasNoNextProto() throws Exception {
        String keystore = MavenTestingUtils.getTestResourceFile((String)"keystore.p12").getAbsolutePath();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystore);
        sslContextFactory.setKeyStorePassword("storepwd");
        HttpConnectionFactory http = new HttpConnectionFactory();
        ProxyConnectionFactory proxy = new ProxyConnectionFactory();
        SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, http.getProtocol());
        DetectorConnectionFactory detector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{ssl, proxy});
        this.start(new ConnectionFactory[]{detector, http});
        String request = "PROXY TCP 1.2.3.4 5.6.7.8 111 222\r\nGET /path HTTP/1.1\nHost: server:80\nConnection: close\n\n";
        String response = this.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testOptionalSsl() throws Exception {
        String keystore = MavenTestingUtils.getTestResourceFile((String)"keystore.p12").getAbsolutePath();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystore);
        sslContextFactory.setKeyStorePassword("storepwd");
        HttpConnectionFactory http = new HttpConnectionFactory();
        SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, http.getProtocol());
        DetectorConnectionFactory detector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{ssl});
        this.start(new ConnectionFactory[]{detector, http});
        String request = "GET /path HTTP/1.1\nHost: server:80\nConnection: close\n\n";
        String clearTextResponse = this.getResponse(request);
        String sslResponse = this.getResponseOverSsl(request);
        MatcherAssert.assertThat((Object)clearTextResponse, (Matcher)Matchers.containsString((String)"HTTP/1.1 200"));
        MatcherAssert.assertThat((Object)sslResponse, (Matcher)Matchers.containsString((String)"HTTP/1.1 200"));
    }

    @Test
    public void testDetectorThatHasNoConfiguredNextProto() throws Exception {
        String keystore = MavenTestingUtils.getTestResourceFile((String)"keystore.p12").getAbsolutePath();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystore);
        sslContextFactory.setKeyStorePassword("storepwd");
        SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString());
        DetectorConnectionFactory detector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{ssl});
        this.start(new ConnectionFactory[]{detector});
        String request = "GET /path HTTP/1.1\nHost: server:80\nConnection: close\n\n";
        String response = this.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testDetectorWithNextProtocolThatDoesNotExist() throws Exception {
        HttpConnectionFactory http = new HttpConnectionFactory();
        ProxyConnectionFactory proxy = new ProxyConnectionFactory("does-not-exist");
        DetectorConnectionFactory detector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{proxy});
        this.start(new ConnectionFactory[]{detector, http});
        String proxyReq = "0D0A0D0A000D0A515549540A2111000CC0A800017f00000130391F90";
        String httpReq = "GET /path HTTP/1.1\nHost: server:80\nConnection: close\n\n";
        String response = this.getResponse(TypeUtil.fromHexString((String)proxyReq), httpReq.getBytes(StandardCharsets.US_ASCII));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testDetectingWithNextProtocolThatDoesNotImplementUpgradeTo() throws Exception {
        ConnectionFactory.Detecting noUpgradeTo = new ConnectionFactory.Detecting(){

            public ConnectionFactory.Detecting.Detection detect(ByteBuffer buffer) {
                return ConnectionFactory.Detecting.Detection.RECOGNIZED;
            }

            public String getProtocol() {
                return "noUpgradeTo";
            }

            public List<String> getProtocols() {
                return Collections.singletonList(this.getProtocol());
            }

            public Connection newConnection(Connector connector, EndPoint endPoint) {
                return new AbstractConnection(null, connector.getExecutor()){

                    public void onFillable() {
                    }
                };
            }
        };
        HttpConnectionFactory http = new HttpConnectionFactory();
        DetectorConnectionFactory detector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{noUpgradeTo});
        this.start(new ConnectionFactory[]{detector, http});
        String proxyReq = "0D0A0D0A000D0A515549540A2111000CC0A800017f00000130391F90";
        String httpReq = "GET /path HTTP/1.1\nHost: server:80\nConnection: close\n\n";
        String response = this.getResponse(TypeUtil.fromHexString((String)proxyReq), httpReq.getBytes(StandardCharsets.US_ASCII));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testDetectorWithNextProtocolThatDoesNotImplementUpgradeTo() throws Exception {
        ConnectionFactory noUpgradeTo = new ConnectionFactory(){

            public String getProtocol() {
                return "noUpgradeTo";
            }

            public List<String> getProtocols() {
                return Collections.singletonList(this.getProtocol());
            }

            public Connection newConnection(Connector connector, EndPoint endPoint) {
                return new AbstractConnection(null, connector.getExecutor()){

                    public void onFillable() {
                    }
                };
            }
        };
        HttpConnectionFactory http = new HttpConnectionFactory();
        ProxyConnectionFactory proxy = new ProxyConnectionFactory(http.getProtocol());
        DetectorConnectionFactory detector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{proxy});
        this.start(new ConnectionFactory[]{detector, noUpgradeTo});
        String request = "GET /path HTTP/1.1\nHost: server:80\nConnection: close\n\n";
        String response = this.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testGeneratedProtocolNames() {
        String keystore = MavenTestingUtils.getTestResourceFile((String)"keystore.p12").getAbsolutePath();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystore);
        sslContextFactory.setKeyStorePassword("storepwd");
        ProxyConnectionFactory proxy = new ProxyConnectionFactory(HttpVersion.HTTP_1_1.asString());
        SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString());
        Assertions.assertEquals((Object)"[SSL|[proxy]]", (Object)new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{ssl, proxy}).getProtocol());
        Assertions.assertEquals((Object)"[[proxy]|SSL]", (Object)new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{proxy, ssl}).getProtocol());
    }

    @Test
    public void testDetectorWithNoDetectingFails() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DetectorConnectionFactory(new ConnectionFactory.Detecting[0]));
    }

    @Test
    public void testExerciseDetectorNotEnoughBytes() throws Exception {
        ConnectionFactory.Detecting detectingNeverRecognizes = new ConnectionFactory.Detecting(){

            public ConnectionFactory.Detecting.Detection detect(ByteBuffer buffer) {
                return ConnectionFactory.Detecting.Detection.NOT_RECOGNIZED;
            }

            public String getProtocol() {
                return "nevergood";
            }

            public List<String> getProtocols() {
                throw new AssertionError();
            }

            public Connection newConnection(Connector connector, EndPoint endPoint) {
                throw new AssertionError();
            }
        };
        ConnectionFactory.Detecting detectingAlwaysNeedMoreBytes = new ConnectionFactory.Detecting(){

            public ConnectionFactory.Detecting.Detection detect(ByteBuffer buffer) {
                return ConnectionFactory.Detecting.Detection.NEED_MORE_BYTES;
            }

            public String getProtocol() {
                return "neverenough";
            }

            public List<String> getProtocols() {
                throw new AssertionError();
            }

            public Connection newConnection(Connector connector, EndPoint endPoint) {
                throw new AssertionError();
            }
        };
        DetectorConnectionFactory detector = new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{detectingNeverRecognizes, detectingAlwaysNeedMoreBytes});
        HttpConnectionFactory http = new HttpConnectionFactory();
        this.start(new ConnectionFactory[]{detector, http});
        String request = "AAAA".repeat(32768);
        try {
            String response = this.getResponse(request);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.nullValue());
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }
}

