/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.logging.StacklessLogging;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ajax.JSON;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ErrorHandlerTest {
    StacklessLogging stacklessLogging;
    Server server;
    LocalConnector connector;

    @BeforeEach
    public void before() throws Exception {
        this.stacklessLogging = new StacklessLogging(new Class[]{HttpChannel.class});
        this.server = new Server();
        this.connector = new LocalConnector(this.server);
        this.server.addConnector((Connector)this.connector);
        this.server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if (baseRequest.getDispatcherType() == DispatcherType.ERROR) {
                    baseRequest.setHandled(true);
                    response.sendError(((Integer)request.getAttribute("jakarta.servlet.error.status_code")).intValue());
                    return;
                }
                if (target.startsWith("/charencoding/")) {
                    baseRequest.setHandled(true);
                    response.setCharacterEncoding("utf-8");
                    response.sendError(404);
                    return;
                }
                if (target.startsWith("/badmessage/")) {
                    int code = Integer.parseInt(target.substring(target.lastIndexOf(47) + 1));
                    throw new ServletException((Throwable)new BadMessageException(code));
                }
                if (target.startsWith("/jsonmessage/")) {
                    String message = "\"}, \"glossary\": {\n \"title\": \"example\"\n }\n {\"";
                    throw new ServletException((Throwable)new RuntimeException(message));
                }
                if (target.startsWith("/xmlmessage/")) {
                    String message = "<!DOCTYPE glossary PUBLIC \"-//OASIS//DTD DocBook V3.1//EN\">\n <glossary>\n  <title>example glossary</title>\n </glossary>";
                    throw new ServletException((Throwable)new RuntimeException(message));
                }
                if (target.startsWith("/htmlmessage/")) {
                    String message = "<hr/><script>alert(42)</script>%3Cscript%3E";
                    throw new ServletException((Throwable)new RuntimeException(message));
                }
                if (target.startsWith("/utf8message/")) {
                    String message = "Euro is &euro; and \u20ac and %E2%82%AC";
                    throw new ServletException((Throwable)new RuntimeException(message));
                }
            }
        });
        this.server.start();
    }

    @AfterEach
    public void after() throws Exception {
        this.server.stop();
        this.stacklessLogging.close();
    }

    @Test
    public void test404NoAccept() throws Exception {
        String rawResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: Localhost\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((String)"Response Content-Length", (Object)response.getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"Response Content-Type", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.containsString((String)"text/html;charset=ISO-8859-1"));
        this.assertContent(response);
    }

    @Test
    public void test404EmptyAccept() throws Exception {
        String rawResponse = this.connector.getResponse("GET / HTTP/1.1\r\nAccept: \r\nHost: Localhost\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((String)"Response Content-Length", (Object)response.getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((String)"Response Content-Type", (Object)response.getField(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void test404UnAccept() throws Exception {
        String rawResponse = this.connector.getResponse("GET / HTTP/1.1\r\nAccept: text/*;q=0\r\nHost: Localhost\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        this.dump(response);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((String)"Response Content-Length", (Object)response.getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((String)"Response Content-Type", (Object)response.getField(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    private void dump(HttpTester.Response response) {
        System.out.println("-------------");
        System.out.println(response);
        System.out.println(response.getContent());
        System.out.println();
    }

    @Test
    public void test404AllAccept() throws Exception {
        String rawResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: Localhost\r\nAccept: */*\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((String)"Response Content-Length", (Object)response.getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"Response Content-Type", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.containsString((String)"text/html;charset=ISO-8859-1"));
        this.assertContent(response);
    }

    @Test
    public void test404HtmlAccept() throws Exception {
        String rawResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: Localhost\r\nAccept: text/html\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((String)"Response Content-Length", (Object)response.getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"Response Content-Type", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.containsString((String)"text/html;charset=ISO-8859-1"));
        this.assertContent(response);
    }

    @Test
    public void testMoreSpecificAccept() throws Exception {
        String rawResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: Localhost\r\nAccept: text/html, some/other;specific=true\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((String)"Response Content-Length", (Object)response.getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"Response Content-Type", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.containsString((String)"text/html;charset=ISO-8859-1"));
        this.assertContent(response);
    }

    @Test
    public void test404HtmlAcceptAnyCharset() throws Exception {
        String rawResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: Localhost\r\nAccept: text/html\r\nAccept-Charset: *\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((String)"Response Content-Length", (Object)response.getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"Response Content-Type", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.containsString((String)"text/html;charset=UTF-8"));
        this.assertContent(response);
    }

    @Test
    public void test404HtmlAcceptUtf8Charset() throws Exception {
        String rawResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: Localhost\r\nAccept: text/html\r\nAccept-Charset: utf-8\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((String)"Response Content-Length", (Object)response.getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"Response Content-Type", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.containsString((String)"text/html;charset=UTF-8"));
        this.assertContent(response);
    }

    @Test
    public void test404HtmlAcceptNotUtf8Charset() throws Exception {
        String rawResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: Localhost\r\nAccept: text/html\r\nAccept-Charset: utf-8;q=0\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((String)"Response Content-Length", (Object)response.getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"Response Content-Type", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.containsString((String)"text/html;charset=ISO-8859-1"));
        this.assertContent(response);
    }

    @Test
    public void test404HtmlAcceptNotUtf8UnknownCharset() throws Exception {
        String rawResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: Localhost\r\nAccept: text/html\r\nAccept-Charset: utf-8;q=0,unknown\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((String)"Response Content-Length", (Object)response.getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((String)"Response Content-Type", (Object)response.getField(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void test404HtmlAcceptUnknownUtf8Charset() throws Exception {
        String rawResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: Localhost\r\nAccept: text/html\r\nAccept-Charset: utf-8;q=0.1,unknown\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((String)"Response Content-Length", (Object)response.getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"Response Content-Type", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.containsString((String)"text/html;charset=UTF-8"));
        this.assertContent(response);
    }

    @Test
    public void test404PreferHtml() throws Exception {
        String rawResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: Localhost\r\nAccept: text/html;q=1.0,text/json;q=0.5,*/*\r\nAccept-Charset: *\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((String)"Response Content-Length", (Object)response.getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"Response Content-Type", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.containsString((String)"text/html;charset=UTF-8"));
        this.assertContent(response);
    }

    @Test
    public void test404PreferJson() throws Exception {
        String rawResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: Localhost\r\nAccept: text/html;q=0.5,text/json;q=1.0,*/*\r\nAccept-Charset: *\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((String)"Response Content-Length", (Object)response.getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"Response Content-Type", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.containsString((String)"text/json"));
        this.assertContent(response);
    }

    @Test
    public void testCharEncoding() throws Exception {
        String rawResponse = this.connector.getResponse("GET /charencoding/foo HTTP/1.1\r\nHost: Localhost\r\nAccept: text/plain\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((String)"Response Content-Length", (Object)response.getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"Response Content-Type", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.containsString((String)"text/plain"));
        this.assertContent(response);
    }

    @Test
    public void testBadMessage() throws Exception {
        String rawResponse = this.connector.getResponse("GET /badmessage/444 HTTP/1.1\r\nHost: Localhost\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)444));
        MatcherAssert.assertThat((String)"Response Content-Length", (Object)response.getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"Response Content-Type", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.containsString((String)"text/html;charset=ISO-8859-1"));
        this.assertContent(response);
    }

    @ParameterizedTest
    @ValueSource(strings={"/jsonmessage/", "/xmlmessage/", "/htmlmessage/", "/utf8message/"})
    public void testComplexCauseMessageNoAcceptHeader(String path) throws Exception {
        String rawResponse = this.connector.getResponse("GET " + path + " HTTP/1.1\r\nHost: Localhost\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
        MatcherAssert.assertThat((String)"Response Content-Length", (Object)response.getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"Response Content-Type", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.containsString((String)"text/html;charset=ISO-8859-1"));
        String content = this.assertContent(response);
        if (path.startsWith("/utf8")) {
            MatcherAssert.assertThat((String)"content", (Object)content, (Matcher)Matchers.containsString((String)"Euro is &amp;euro; and ? and %E2%82%AC"));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"/jsonmessage/", "/xmlmessage/", "/htmlmessage/", "/utf8message/"})
    public void testComplexCauseMessageAcceptUtf8Header(String path) throws Exception {
        String rawResponse = this.connector.getResponse("GET " + path + " HTTP/1.1\r\nHost: Localhost\r\nAccept: text/html\r\nAccept-Charset: utf-8\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        System.out.println("response: " + response);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
        MatcherAssert.assertThat((String)"Response Content-Length", (Object)response.getField(HttpHeader.CONTENT_LENGTH).getIntValue(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"Response Content-Type", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.containsString((String)"text/html;charset=UTF-8"));
        String content = this.assertContent(response);
        if (path.startsWith("/utf8")) {
            MatcherAssert.assertThat((String)"content", (Object)content, (Matcher)Matchers.containsString((String)"Euro is &amp;euro; and \u20ac and %E2%82%AC"));
        }
    }

    private String assertContent(HttpTester.Response response) {
        String contentType = response.get(HttpHeader.CONTENT_TYPE);
        String content = response.getContent();
        if (contentType.contains("text/html")) {
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"<script>")));
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"<glossary>")));
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"<!DOCTYPE>")));
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"&euro;")));
        } else if (contentType.contains("text/json")) {
            Map jo = (Map)new JSON().fromJSON(response.getContent());
            HashSet<String> acceptableKeyNames = new HashSet<String>();
            acceptableKeyNames.add("url");
            acceptableKeyNames.add("status");
            acceptableKeyNames.add("message");
            acceptableKeyNames.add("servlet");
            acceptableKeyNames.add("cause0");
            acceptableKeyNames.add("cause1");
            acceptableKeyNames.add("cause2");
            for (Object key : jo.keySet()) {
                String keyStr = (String)key;
                Assertions.assertTrue((boolean)acceptableKeyNames.contains(keyStr), (String)("Unexpected Key [" + keyStr + "]"));
                Object value = jo.get(key);
                MatcherAssert.assertThat((String)("Unexpected value type (" + value.getClass().getName() + ")"), value, (Matcher)Matchers.instanceOf(String.class));
            }
            MatcherAssert.assertThat((String)"url field", jo.get("url"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            String expectedStatus = String.valueOf(response.getStatus());
            MatcherAssert.assertThat((String)"status field", jo.get("status"), (Matcher)Matchers.is((Object)expectedStatus));
            String message = (String)jo.get("message");
            MatcherAssert.assertThat((String)"message field", (Object)message, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((String)"message field", (Object)message, (Matcher)Matchers.anyOf((Matcher)Matchers.not((Matcher)Matchers.containsString((String)"<")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)">"))));
        } else if (contentType.contains("text/plain")) {
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.containsString((String)("STATUS: " + response.getStatus())));
        } else {
            System.out.println("Not checked Content-Type: " + contentType);
            System.out.println(content);
        }
        return content;
    }

    @Test
    public void testJsonResponse() throws Exception {
        String rawResponse = this.connector.getResponse("GET /badmessage/444 HTTP/1.1\r\nHost: Localhost\r\nAccept: text/json\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)444));
        this.assertContent(response);
    }

    @ParameterizedTest
    @ValueSource(strings={"/jsonmessage/", "/xmlmessage/", "/htmlmessage/", "/utf8message/"})
    public void testJsonResponseWorse(String path) throws Exception {
        String rawResponse = this.connector.getResponse("GET " + path + " HTTP/1.1\r\nHost: Localhost\r\nAccept: text/json\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response status code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
        String content = this.assertContent(response);
        if (path.startsWith("/utf8")) {
            MatcherAssert.assertThat((String)"content", (Object)content, (Matcher)Matchers.containsString((String)"Euro is &amp;euro; and \u20ac and %E2%82%AC"));
        }
    }

    @Test
    public void testErrorContextRecycle() throws Exception {
        this.server.stop();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this.server.setHandler((Handler)contexts);
        ContextHandler context = new ContextHandler("/foo");
        contexts.addHandler((Handler)context);
        context.setErrorHandler(new ErrorHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.getOutputStream().println("Context Error");
            }
        });
        context.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                response.sendError(444);
            }
        });
        this.server.setErrorHandler(new ErrorHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.getOutputStream().println("Server Error");
            }
        });
        this.server.start();
        LocalConnector.LocalEndPoint connection = this.connector.connect();
        connection.addInputAndExecute(BufferUtil.toBuffer((String)"GET /foo/test HTTP/1.1\r\nHost: Localhost\r\n\r\n"));
        String response = connection.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 444 444"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Context Error"));
        connection.addInputAndExecute(BufferUtil.toBuffer((String)"GET /test HTTP/1.1\r\nHost: Localhost\r\n\r\n"));
        response = connection.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 404 Not Found"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Server Error"));
    }
}

