/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.FuturePromise;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Graceful;
import org.eclipse.jetty.util.component.LifeCycle;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GracefulStopTest {
    static byte[] POST_12345 = "POST / HTTP/1.1\r\nHost: localhost\r\nContent-Type: plain/text\r\nContent-Length: 10\r\n\r\n12345".getBytes(StandardCharsets.ISO_8859_1);
    static byte[] POST_A_12345 = "POST /a/ HTTP/1.1\r\nHost: localhost\r\nContent-Type: plain/text\r\nContent-Length: 10\r\n\r\n12345".getBytes(StandardCharsets.ISO_8859_1);
    static byte[] POST_B_12345 = "POST /b/ HTTP/1.1\r\nHost: localhost\r\nContent-Type: plain/text\r\nContent-Length: 10\r\n\r\n12345".getBytes(StandardCharsets.ISO_8859_1);
    static byte[] POST_12345_C = "POST /?commit=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: plain/text\r\nContent-Length: 10\r\n\r\n12345".getBytes(StandardCharsets.ISO_8859_1);
    static byte[] POST_A_12345_C = "POST /a/?commit=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: plain/text\r\nContent-Length: 10\r\n\r\n12345".getBytes(StandardCharsets.ISO_8859_1);
    static byte[] POST_B_12345_C = "POST /b/?commit=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: plain/text\r\nContent-Length: 10\r\n\r\n12345".getBytes(StandardCharsets.ISO_8859_1);
    static byte[] BODY_67890 = "67890".getBytes(StandardCharsets.ISO_8859_1);
    Server server = new Server();
    ServerConnector connector = new ServerConnector(this.server);
    HandlerList handlers = new HandlerList();
    ContextHandlerCollection contexts = new ContextHandlerCollection();
    ContextHandler contextA = new ContextHandler((HandlerContainer)this.contexts, "/a");
    TestHandler handlerA = new TestHandler();
    ContextHandler contextB = new ContextHandler((HandlerContainer)this.contexts, "/b");
    StatisticsHandler statsB = new StatisticsHandler();
    TestHandler handlerB = new TestHandler();
    TestHandler handler = new TestHandler();

    @BeforeEach
    public void beforeEach() throws Exception {
        this.connector.setIdleTimeout(10000L);
        this.connector.setShutdownIdleTimeout(1000L);
        this.connector.setPort(0);
        this.server.addConnector((Connector)this.connector);
        this.server.setHandler((Handler)this.handlers);
        this.handlers.addHandler((Handler)this.contexts);
        this.handlers.addHandler((Handler)this.handler);
        this.contextA.setHandler((Handler)this.handlerA);
        this.contextB.setHandler((Handler)this.statsB);
        this.statsB.setHandler((Handler)this.handlerB);
        this.server.setStopTimeout(10000L);
        this.server.start();
    }

    Socket newClientBusy(byte[] post, TestHandler handler) throws Exception {
        handler.latch = new CountDownLatch(1);
        int port = this.connector.getLocalPort();
        Socket client = new Socket("127.0.0.1", port);
        client.getOutputStream().write(post);
        client.getOutputStream().flush();
        Assertions.assertTrue((boolean)handler.latch.await(5L, TimeUnit.SECONDS));
        return client;
    }

    Socket newClientIdle(byte[] post, TestHandler handler) throws Exception {
        handler.latch = new CountDownLatch(1);
        int port = this.connector.getLocalPort();
        Socket client = new Socket("127.0.0.1", port);
        client.getOutputStream().write(post);
        client.getOutputStream().write(BODY_67890);
        client.getOutputStream().flush();
        Assertions.assertTrue((boolean)handler.latch.await(5L, TimeUnit.SECONDS));
        HttpTester.Response response = HttpTester.parseResponse((InputStream)client.getInputStream());
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"read 10/10\n"));
        MatcherAssert.assertThat((Object)response.get(HttpHeader.CONNECTION), (Matcher)Matchers.nullValue());
        return client;
    }

    void assertAvailable(Socket client, byte[] post, TestHandler handler) throws Exception {
        handler.latch = new CountDownLatch(1);
        client.getOutputStream().write(post);
        client.getOutputStream().write(BODY_67890);
        client.getOutputStream().flush();
        Assertions.assertTrue((boolean)handler.latch.await(5L, TimeUnit.SECONDS));
        HttpTester.Response response = HttpTester.parseResponse((InputStream)client.getInputStream());
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"read 10/10\n"));
        MatcherAssert.assertThat((Object)response.get(HttpHeader.CONNECTION), (Matcher)Matchers.nullValue());
    }

    Future<Integer> backgroundUnavailable(Socket client, byte[] post, ContextHandler context, TestHandler handler) throws Exception {
        FuturePromise future = new FuturePromise();
        long start = System.nanoTime();
        new Thread(() -> {
            try {
                while (context.isAvailable()) {
                    MatcherAssert.assertThat((Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(5000L)));
                    Thread.sleep(100L);
                }
                client.getOutputStream().write(post);
                client.getOutputStream().write(BODY_67890);
                client.getOutputStream().flush();
                HttpTester.Response response = HttpTester.parseResponse((InputStream)client.getInputStream());
                future.succeeded((Object)response.getStatus());
            }
            catch (Exception e) {
                future.failed((Throwable)e);
            }
        }).start();
        return future;
    }

    void assertQuickStop() throws Exception {
        long start = System.nanoTime();
        this.server.stop();
        long stop = System.nanoTime();
        long duration = TimeUnit.NANOSECONDS.toMillis(stop - start);
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(2000L)));
    }

    void assertGracefulStop(LifeCycle lifecycle) throws Exception {
        long start = System.nanoTime();
        lifecycle.stop();
        long stop = System.nanoTime();
        long duration = TimeUnit.NANOSECONDS.toMillis(stop - start);
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(50L)));
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(5000L)));
    }

    void assertResponse(Socket client, boolean close) throws Exception {
        HttpTester.Response response = HttpTester.parseResponse((InputStream)client.getInputStream());
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        if (close) {
            MatcherAssert.assertThat((Object)response.get(HttpHeader.CONNECTION), (Matcher)Matchers.is((Object)"close"));
        } else {
            MatcherAssert.assertThat((Object)response.get(HttpHeader.CONNECTION), (Matcher)Matchers.nullValue());
        }
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"read 10/10\n"));
    }

    void assert500Response(Socket client) throws Exception {
        HttpTester.Response response = HttpTester.parseResponse((InputStream)client.getInputStream());
        if (response != null) {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
            MatcherAssert.assertThat((Object)response.get(HttpHeader.CONNECTION), (Matcher)Matchers.is((Object)"close"));
        }
    }

    void assertQuickClose(Socket client) throws Exception {
        long start = System.nanoTime();
        MatcherAssert.assertThat((Object)client.getInputStream().read(), (Matcher)Matchers.is((Object)-1));
        long stop = System.nanoTime();
        long duration = TimeUnit.NANOSECONDS.toMillis(stop - start);
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(2000L)));
    }

    void assertHandled(TestHandler handler, boolean error) {
        MatcherAssert.assertThat((Object)handler.handling.get(), (Matcher)Matchers.is((Object)false));
        if (error) {
            MatcherAssert.assertThat((Object)handler.thrown.get(), (Matcher)Matchers.notNullValue());
        } else {
            MatcherAssert.assertThat((Object)handler.thrown.get(), (Matcher)Matchers.nullValue());
        }
    }

    void backgroundComplete(Socket client, TestHandler handler) throws Exception {
        long start = System.nanoTime();
        new Thread(() -> {
            try {
                handler.latch.await();
                long now = System.nanoTime();
                Thread.sleep(100L - TimeUnit.NANOSECONDS.toMillis(now - start));
                client.getOutputStream().write(BODY_67890);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    @Test
    public void testNotGraceful() throws Exception {
        this.server.setStopTimeout(0L);
        this.server.start();
        Socket client0 = this.newClientBusy(POST_12345, this.handler);
        Socket client1 = this.newClientIdle(POST_12345, this.handler);
        this.assertQuickStop();
        this.assertQuickClose(client0);
        this.assertQuickClose(client1);
        this.assertHandled(this.handler, true);
    }

    @Test
    public void testGracefulConnection() throws Exception {
        Socket client0 = this.newClientBusy(POST_12345, this.handler);
        Socket client1 = this.newClientBusy(POST_12345_C, this.handler);
        Socket client2 = this.newClientIdle(POST_12345, this.handler);
        this.backgroundComplete(client0, this.handler);
        this.backgroundComplete(client1, this.handler);
        this.assertGracefulStop((LifeCycle)this.server);
        this.assertResponse(client0, true);
        this.assertResponse(client1, false);
        this.assertQuickClose(client0);
        this.assertQuickClose(client1);
        this.assertQuickClose(client2);
        this.assertHandled(this.handler, false);
    }

    @Test
    public void testGracefulConnectionNotComplete() throws Exception {
        this.server.setStopTimeout(3000L);
        Socket client0 = this.newClientBusy(POST_12345, this.handler);
        Socket client1 = this.newClientBusy(POST_12345_C, this.handler);
        Socket client2 = this.newClientIdle(POST_12345, this.handler);
        this.assertGracefulStop((LifeCycle)this.server);
        this.assert500Response(client0);
        this.assert500Response(client1);
        this.assertQuickClose(client0);
        this.assertQuickClose(client1);
        this.assertQuickClose(client2);
        this.assertHandled(this.handler, true);
    }

    @Test
    public void testGracefulWithContext() throws Exception {
        Socket client0 = this.newClientBusy(POST_A_12345, this.handlerA);
        Socket client1 = this.newClientBusy(POST_A_12345_C, this.handlerA);
        Socket client2 = this.newClientIdle(POST_A_12345, this.handlerA);
        this.backgroundComplete(client0, this.handlerA);
        this.backgroundComplete(client1, this.handlerA);
        Future<Integer> status2 = this.backgroundUnavailable(client2, POST_A_12345, this.contextA, this.handlerA);
        this.assertGracefulStop((LifeCycle)this.server);
        this.assertResponse(client0, true);
        this.assertResponse(client1, false);
        MatcherAssert.assertThat((Object)status2.get(), (Matcher)Matchers.is((Object)503));
        this.assertQuickClose(client0);
        this.assertQuickClose(client1);
        this.assertQuickClose(client2);
        this.assertHandled(this.handlerA, false);
    }

    @Test
    public void testGracefulContext() throws Exception {
        Socket client0 = this.newClientBusy(POST_B_12345, this.handlerB);
        Socket client1 = this.newClientBusy(POST_B_12345_C, this.handlerB);
        Socket client2 = this.newClientIdle(POST_B_12345, this.handlerB);
        this.backgroundComplete(client0, this.handlerB);
        this.backgroundComplete(client1, this.handlerB);
        Future<Integer> status2 = this.backgroundUnavailable(client2, POST_B_12345, this.contextB, this.handlerB);
        Graceful.shutdown((Container)this.contextB).orTimeout(10L, TimeUnit.SECONDS).get();
        this.assertResponse(client0, false);
        this.assertResponse(client1, false);
        MatcherAssert.assertThat((Object)status2.get(), (Matcher)Matchers.is((Object)503));
        this.assertAvailable(client0, POST_A_12345, this.handlerA);
        this.assertAvailable(client1, POST_A_12345_C, this.handlerA);
        this.assertAvailable(client2, POST_A_12345, this.handlerA);
        this.assertHandled(this.handlerA, false);
        this.assertHandled(this.handlerB, false);
    }

    static class TestHandler
    extends AbstractHandler {
        final AtomicReference<Throwable> thrown = new AtomicReference();
        final AtomicBoolean handling = new AtomicBoolean(false);
        volatile CountDownLatch latch;

        TestHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            CountDownLatch l;
            this.handling.set(true);
            baseRequest.setHandled(true);
            response.setStatus(200);
            if ("true".equals(request.getParameter("commit"))) {
                response.flushBuffer();
            }
            if ((l = this.latch) != null) {
                l.countDown();
            }
            int c = 0;
            try {
                int contentLength = request.getContentLength();
                if (contentLength > 0) {
                    ServletInputStream in = request.getInputStream();
                    while (in.read() >= 0) {
                        ++c;
                    }
                }
                response.getWriter().printf("read %d/%d%n", c, contentLength);
            }
            catch (Throwable th) {
                this.thrown.set(th);
                throw th;
            }
            finally {
                this.handling.set(false);
            }
        }
    }
}

