/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import jakarta.servlet.ReadListener;
import java.io.EOFException;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.MockConnector;
import org.eclipse.jetty.util.BufferUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HttpInputTest {
    private final Queue<String> _history = new LinkedBlockingQueue<String>();
    private final Queue<String> _fillAndParseSimulate = new LinkedBlockingQueue<String>();
    private final ReadListener _listener = new ReadListener(){

        public void onError(Throwable t) {
            HttpInputTest.this._history.add("l.onError:" + t);
        }

        public void onDataAvailable() throws IOException {
            HttpInputTest.this._history.add("l.onDataAvailable");
        }

        public void onAllDataRead() throws IOException {
            HttpInputTest.this._history.add("l.onAllDataRead");
        }
    };
    private HttpInput _in;

    @BeforeEach
    public void before() {
        this._in = new TestHttpInput(new TestHttpChannelState(new HttpChannel((Connector)new MockConnector(), new HttpConfiguration(), null, null){

            public void onAsyncWaitForContent() {
                HttpInputTest.this._history.add("asyncReadInterested");
            }
        }));
    }

    @AfterEach
    public void after() {
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testEmpty() throws Exception {
        MatcherAssert.assertThat((Object)this._in.available(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"produceContent 0"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testRead() throws Exception {
        this._in.addContent((HttpInput.Content)new TContent("AB"));
        this._in.addContent((HttpInput.Content)new TContent("CD"));
        this._fillAndParseSimulate.offer("EF");
        this._fillAndParseSimulate.offer("GH");
        MatcherAssert.assertThat((Object)this._in.available(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this._in.getContentConsumed(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)65));
        MatcherAssert.assertThat((Object)this._in.getContentConsumed(), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)66));
        MatcherAssert.assertThat((Object)this._in.getContentConsumed(), (Matcher)Matchers.equalTo((Object)2L));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded AB"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)67));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)68));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded CD"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)69));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)70));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"produceContent 2"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded EF"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)71));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)72));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded GH"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.getContentConsumed(), (Matcher)Matchers.equalTo((Object)8L));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testBlockingRead() throws Exception {
        new Thread(() -> {
            try {
                Thread.sleep(500L);
                this._in.addContent((HttpInput.Content)new TContent("AB"));
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }).start();
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)65));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"produceContent 0"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"blockForContent"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)66));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded AB"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testReadEOF() throws Exception {
        this._in.addContent((HttpInput.Content)new TContent("AB"));
        this._in.addContent((HttpInput.Content)new TContent("CD"));
        this._in.eof();
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._in.available(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)65));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)66));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded AB"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)67));
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)68));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded CD"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)-1));
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testReadEarlyEOF() throws Exception {
        this._in.addContent((HttpInput.Content)new TContent("AB"));
        this._in.addContent((HttpInput.Content)new TContent("CD"));
        this._in.earlyEOF();
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._in.available(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)65));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)66));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)67));
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)68));
        Assertions.assertThrows(EOFException.class, () -> this._in.read());
        Assertions.assertTrue((boolean)this._in.isFinished());
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded AB"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded CD"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testBlockingEOF() throws Exception {
        new Thread(() -> {
            try {
                Thread.sleep(500L);
                this._in.eof();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }).start();
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)-1));
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"produceContent 0"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"blockForContent"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testAsyncEmpty() throws Exception {
        ((TestHttpChannelState)this._in.getHttpChannelState()).setFakeAsyncState(true);
        this._in.setReadListener(this._listener);
        ((TestHttpChannelState)this._in.getHttpChannelState()).setFakeAsyncState(false);
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"produceContent 0"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"s.onReadUnready"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testAsyncRead() throws Exception {
        ((TestHttpChannelState)this._in.getHttpChannelState()).setFakeAsyncState(true);
        this._in.setReadListener(this._listener);
        ((TestHttpChannelState)this._in.getHttpChannelState()).setFakeAsyncState(false);
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"produceContent 0"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"s.onReadUnready"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        this._in.addContent((HttpInput.Content)new TContent("AB"));
        this._fillAndParseSimulate.add("CD");
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"s.onDataAvailable"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        this._in.run();
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"l.onDataAvailable"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)65));
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)66));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded AB"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"produceContent 1"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"s.onDataAvailable"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)67));
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)68));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded CD"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"produceContent 0"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"s.onReadUnready"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testAsyncEOF() throws Exception {
        ((TestHttpChannelState)this._in.getHttpChannelState()).setFakeAsyncState(true);
        this._in.setReadListener(this._listener);
        ((TestHttpChannelState)this._in.getHttpChannelState()).setFakeAsyncState(false);
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"produceContent 0"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"s.onReadUnready"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        this._in.eof();
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"s.onDataAvailable"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)-1));
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testAsyncReadEOF() throws Exception {
        ((TestHttpChannelState)this._in.getHttpChannelState()).setFakeAsyncState(true);
        this._in.setReadListener(this._listener);
        ((TestHttpChannelState)this._in.getHttpChannelState()).setFakeAsyncState(false);
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"produceContent 0"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"s.onReadUnready"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        this._in.addContent((HttpInput.Content)new TContent("AB"));
        this._fillAndParseSimulate.add("_EOF_");
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"s.onDataAvailable"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        this._in.run();
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"l.onDataAvailable"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)65));
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)66));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded AB"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"produceContent 1"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"s.onDataAvailable"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)-1));
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testAsyncError() throws Exception {
        ((TestHttpChannelState)this._in.getHttpChannelState()).setFakeAsyncState(true);
        this._in.setReadListener(this._listener);
        ((TestHttpChannelState)this._in.getHttpChannelState()).setFakeAsyncState(false);
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"produceContent 0"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"s.onReadUnready"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        this._in.failed((Throwable)new TimeoutException());
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"s.onDataAvailable"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        this._in.run();
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"l.onError:java.util.concurrent.TimeoutException"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this._in.isReady(), (Matcher)Matchers.equalTo((Object)true));
        IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> this._in.read());
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(TimeoutException.class));
        MatcherAssert.assertThat((Object)this._in.isFinished(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testSetListenerWithNull() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> this._in.setReadListener(null));
    }

    @Test
    public void testSetListenerNotAsync() throws Exception {
        Assertions.assertThrows(IllegalStateException.class, () -> this._in.setReadListener(this._listener));
    }

    @Test
    public void testSetListenerAlreadySet() throws Exception {
        ((TestHttpChannelState)this._in.getHttpChannelState()).setFakeAsyncState(true);
        this._in.setReadListener(this._listener);
        this._history.clear();
        ((TestHttpChannelState)this._in.getHttpChannelState()).setFakeAsyncState(false);
        Assertions.assertThrows(IllegalStateException.class, () -> this._in.setReadListener(this._listener));
    }

    @Test
    public void testRecycle() throws Exception {
        this.testAsyncRead();
        this._in.recycle();
        this.testAsyncRead();
        this._in.recycle();
        this.testReadEOF();
    }

    @Test
    public void testConsumeAll() throws Exception {
        this._in.addContent((HttpInput.Content)new TContent("AB"));
        this._in.addContent((HttpInput.Content)new TContent("CD"));
        this._fillAndParseSimulate.offer("EF");
        this._fillAndParseSimulate.offer("GH");
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)65));
        Assertions.assertFalse((boolean)this._in.consumeAll());
        MatcherAssert.assertThat((Object)this._in.getContentConsumed(), (Matcher)Matchers.equalTo((Object)8L));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded AB"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded CD"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"produceContent 2"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded EF"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded GH"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"produceContent 0"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testConsumeAllEOF() throws Exception {
        this._in.addContent((HttpInput.Content)new TContent("AB"));
        this._in.addContent((HttpInput.Content)new TContent("CD"));
        this._fillAndParseSimulate.offer("EF");
        this._fillAndParseSimulate.offer("GH");
        this._fillAndParseSimulate.offer("_EOF_");
        MatcherAssert.assertThat((Object)this._in.read(), (Matcher)Matchers.equalTo((Object)65));
        Assertions.assertTrue((boolean)this._in.consumeAll());
        MatcherAssert.assertThat((Object)this._in.getContentConsumed(), (Matcher)Matchers.equalTo((Object)8L));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded AB"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded CD"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"produceContent 3"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded EF"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.equalTo((Object)"Content succeeded GH"));
        MatcherAssert.assertThat((Object)this._history.poll(), (Matcher)Matchers.nullValue());
    }

    public class TestHttpChannelState
    extends HttpChannelState {
        private boolean _fakeAsyncState;

        public TestHttpChannelState(HttpChannel channel) {
            super(channel);
        }

        public boolean isFakeAsyncState() {
            return this._fakeAsyncState;
        }

        public void setFakeAsyncState(boolean fakeAsyncState) {
            this._fakeAsyncState = fakeAsyncState;
        }

        public boolean isAsyncStarted() {
            if (this.isFakeAsyncState()) {
                return true;
            }
            return super.isAsyncStarted();
        }

        public void onReadUnready() {
            HttpInputTest.this._history.add("s.onReadUnready");
            super.onReadUnready();
        }

        public boolean onReadPossible() {
            HttpInputTest.this._history.add("s.onReadPossible");
            return super.onReadPossible();
        }

        public boolean onContentAdded() {
            HttpInputTest.this._history.add("s.onDataAvailable");
            return super.onContentAdded();
        }

        public boolean onReadReady() {
            HttpInputTest.this._history.add("s.onReadReady");
            return super.onReadReady();
        }
    }

    public class TestHttpInput
    extends HttpInput {
        public TestHttpInput(HttpChannelState state) {
            super(state);
        }

        protected void produceContent() throws IOException {
            HttpInputTest.this._history.add("produceContent " + HttpInputTest.this._fillAndParseSimulate.size());
            String s = HttpInputTest.this._fillAndParseSimulate.poll();
            while (s != null) {
                if ("_EOF_".equals(s)) {
                    HttpInputTest.this._in.eof();
                } else {
                    HttpInputTest.this._in.addContent((HttpInput.Content)new TContent(s));
                }
                s = HttpInputTest.this._fillAndParseSimulate.poll();
            }
        }

        protected void blockForContent() throws IOException {
            HttpInputTest.this._history.add("blockForContent");
            super.blockForContent();
        }
    }

    public class TContent
    extends HttpInput.Content {
        private final String _content;

        public TContent(String content) {
            super(BufferUtil.toBuffer((String)content));
            this._content = content;
        }

        public void succeeded() {
            HttpInputTest.this._history.add("Content succeeded " + this._content);
            super.succeeded();
        }

        public void failed(Throwable x) {
            HttpInputTest.this._history.add("Content failed " + this._content);
            super.failed(x);
        }
    }
}

